/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.Lanczos;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Gamma
extends UnivariateRealFunction {
    private Method G;
    private final Lanczos M;
    private final int m;
    private final double H;

    private double i(double a2) {
        Gamma a3;
        double a4 = a3.M.logGamma(a2);
        a4 = Math.exp(a4);
        return a4;
    }

    private double H(double a2, double a3) {
        double a4 = Math.PI / a2;
        a4 /= a3;
        return a4 /= Math.sin(-a2 * Math.PI);
    }

    public Gamma(double g2, int n, int scale) {
        this.G = Method.LANCZOS;
        this.M = new Lanczos(g2, n, scale);
        this.H = 0.0;
        this.m = 0;
    }

    public double evaluate(double x2) {
        double a2 = Double.POSITIVE_INFINITY;
        if (DoubleUtils.compare(x2, 0.0) == 0) {
            return a2;
        }
        double a3 = x2 > 0.0 ? x2 : -x2;
        switch (this.G) {
            case GERGO_NEMES: {
                a2 = this.H(a3);
                break;
            }
            case LANCZOS_QUICK: {
                do {
                } while (false);
                a2 = this.C(a3);
                break;
            }
            default: {
                a2 = this.i(a3);
            }
        }
        a2 = x2 > 0.0 ? a2 : this.H(-x2, a2);
        return a2;
    }

    @Deprecated
    private double h(double a2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public Gamma() {
        this.G = Method.LANCZOS_QUICK;
        this.M = new Lanczos();
        this.H = 0.0;
        this.m = 0;
    }

    @Deprecated
    private double e(double a2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    private double C(double a2) {
        Gamma a3;
        double a4 = a3.M.logGammaQuick(a2);
        a4 = Math.exp(a4);
        return a4;
    }

    public Gamma(Method method) {
        this.G = method;
        this.M = new Lanczos();
        this.m = 49;
        this.H = Constant.EPSILON;
    }

    private double H(double a2) {
        double a3 = Math.sqrt(Math.PI * 2 / a2);
        double a4 = Math.pow((a2 + 1.0 / (12.0 * a2 - 0.1 * a2)) / Math.E, a2);
        double a5 = a3 * a4;
        return a5;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LANCZOS = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method GERGO_NEMES;
        public static final /* enum */ Method LANCZOS_QUICK;

        private Method() {
            Method a2;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        static {
            LANCZOS_QUICK = new Method();
            GERGO_NEMES = new Method();
            Method[] methodArray = new Method[3];
            methodArray[0] = LANCZOS;
            methodArray[1] = LANCZOS_QUICK;
            methodArray[2] = GERGO_NEMES;
            $VALUES = methodArray;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

