/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.ErfInverse;
import com.numericalmethod.suanshu.analysis.function.special.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.analysis.uniroot.Halley;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class GammaRegularizedPInverse
extends BivariateRealFunction {
    private static final Gamma J = new Gamma();
    private static final Polynomial C;
    private static final LogGamma F;
    private static final Polynomial B;
    private static final Polynomial G;
    private static final Polynomial M;
    private static final GammaRegularizedP m;
    private static final Polynomial H;

    public double evaluate(final double s, final double u2) {
        SuanShuUtils.assertArgument(s > 0.0, b.C("j8wlnl>{t8,9e"));
        double a2 = 0.0;
        if (DoubleUtils.compare(u2, 0.0) == 0) {
            return 0.0;
        }
        if (DoubleUtils.compare(u2, 1.0) == 0) {
            return Double.POSITIVE_INFINITY;
        }
        a2 = DoubleUtils.compare(s, 1.0) <= 0 ? this.evaluateByApproximation(s, u2) : this.evaluateByAsymptoticInversion(s, u2);
        UnivariateRealFunction a3 = new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                return m.evaluate(s, x2) - u2;
            }
        };
        UnivariateRealFunction a4 = new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double x2) {
                double a2 = -x2;
                a2 += (s - 1.0) * Math.log(x2);
                a2 -= F.evaluate(s);
                a2 = Math.exp(a2);
                return a2;
            }
        };
        UnivariateRealFunction a5 = new UnivariateRealFunction(){
            {
                3 a2;
            }

            public double evaluate(double x2) {
                double a2 = -x2;
                a2 += (s - 2.0) * Math.log(x2);
                a2 -= F.evaluate(s);
                a2 = Math.exp(a2);
                return a2 *= -x2 + s - 1.0;
            }
        };
        double a6 = new Halley(a3, a4, a5, 1.0E-16).solve(50, a2);
        return a6;
    }

    static {
        F = new LogGamma();
        m = new GammaRegularizedP();
        double[] dArray = new double[6];
        dArray[0] = -2.8741263309164543E-5;
        dArray[1] = 2.755731922398589E-4;
        dArray[2] = -0.0010802469135802468;
        dArray[3] = 6.172839506172839E-4;
        dArray[4] = 0.027777777777777776;
        dArray[5] = -0.3333333333333333;
        B = new Polynomial(dArray);
        double[] dArray2 = new double[5];
        dArray2[0] = 6.229995427526292E-5;
        dArray2[1] = -7.520766651425087E-4;
        dArray2[2] = 0.002611209092690574;
        dArray2[3] = -0.002700617283950617;
        dArray2[4] = -0.01728395061728395;
        H = new Polynomial(dArray2);
        double[] dArray3 = new double[4];
        dArray3[0] = 6.554653913335898E-5;
        dArray3[1] = 7.956376423454613E-4;
        dArray3[2] = -0.003007782731290962;
        dArray3[3] = 0.004399372917891437;
        G = new Polynomial(dArray3);
        double[] dArray4 = new double[4];
        dArray4[0] = 2.9719735544227286E-4;
        dArray4[1] = -4.5808052481112146E-4;
        dArray4[2] = -6.36443186258144E-5;
        dArray4[3] = 0.0017364513249286911;
        M = new Polynomial(dArray4);
        double[] dArray5 = new double[6];
        dArray5[0] = 2.314814814814815E-4;
        dArray5[1] = -0.003703703703703704;
        dArray5[2] = 0.027777777777777776;
        dArray5[3] = 0.3333333333333333;
        dArray5[4] = 1.0;
        dArray5[5] = 1.0;
        C = new Polynomial(dArray5);
    }

    double evaluateByAsymptoticInversion(double a2, double a3) {
        double a4;
        double a5;
        double a6;
        double a7;
        double a8;
        double a9;
        double a10;
        double a11;
        double a12 = new ErfInverse().evaluate(1.0 - 2.0 * a3) / Math.sqrt(a2 / 2.0);
        if ((a11 = C.evaluate(a10 = (a12 *= -1.0) + (a9 = ((a8 = B.evaluate(a12)) + ((a7 = H.evaluate(a12)) + ((a6 = G.evaluate(a12)) + (a5 = M.evaluate(a12)) / a2) / a2) / a2) / a2))) < 0.0) {
            GammaRegularizedPInverse a13;
            a4 = 0.5 * a12 * a12;
            Halley a14 = new Halley(new UnivariateRealFunction(){
                {
                    4 a2;
                }

                public double evaluate(double x2) {
                    return x2 - 1.0 - Math.log(x2) - a4;
                }
            }, new UnivariateRealFunction(){
                {
                    5 a2;
                }

                public double evaluate(double x2) {
                    return 1.0 - 1.0 / x2;
                }
            }, new UnivariateRealFunction(){
                {
                    6 a2;
                }

                public double evaluate(double x2) {
                    return 1.0 - 1.0 / x2 / x2;
                }
            }, Constant.EPSILON);
            a11 = a14.solve(50, a4);
        }
        a4 = a2 * a11;
        return a4;
    }

    double evaluateByApproximation(double a2, double a3) {
        double a4 = Math.pow(a3 * J.evaluate(a2 + 1.0), 1.0 / a2);
        double a5 = m.evaluate(a2, a4) - a3;
        double a6 = -Math.pow(a4, 1.0 - a2);
        a6 *= Math.exp(a4);
        double a7 = (a6 *= J.evaluate(a2)) * a6;
        a7 *= a4 + 1.0 - a2;
        a7 /= 2.0 * a4;
        double a8 = a2 * a2;
        double a9 = a6 * a6 * a6;
        a9 *= 2.0 * a4 * a4 + 4.0 * a4 * (1.0 - a2) + 2.0 * a8 - 3.0 * a2 + 1.0;
        double a10 = a4 * a4 * a4;
        double a11 = a6 * a6 * a6 * a6;
        a11 *= 6.0 * a10 + 18.0 * a4 * a4 * (1.0 - a2) + a4 * (18.0 * a8 - 29.0 * a2 + 11.0) - 6.0 * a2 * a8 + 11.0 * a8 - 6.0 * a2 + 1.0;
        double a12 = (a6 + (a7 + ((a9 /= 6.0 * a4 * a4) + (a11 /= 24.0 * a10) * a5) * a5) * a5) * a5;
        return a4 + a12;
    }
}

