/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.generic.matrixtype.RealMatrix;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.number.big.BigDecimalUtils;
import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

class Lanczos {
    final double g;
    final RealMatrix C;
    final int n;
    final RealMatrix F;
    final RealMatrix D;
    final RealMatrix B;
    final int scale;
    final RealMatrix P;
    final DenseMatrix P4double;

    RealMatrix Z(BigDecimal a2) {
        int a3;
        Lanczos a4;
        RealMatrix a5 = new RealMatrix(1, a4.n);
        a5.set(1, 1, Real.ONE);
        int n = a3 = 1;
        while (n < a4.n) {
            BigDecimal a6 = BigDecimal.ONE;
            BigDecimal[] bigDecimalArray = new BigDecimal[2];
            bigDecimalArray[0] = a2;
            bigDecimalArray[1] = new BigDecimal(a3);
            a6 = a6.divide(BigDecimalUtils.sum(bigDecimalArray), a4.scale, 6);
            a5.set(1, a3 + 1, new Real(a6));
            n = ++a3;
        }
        return a5;
    }

    private RealMatrix G() {
        int a2;
        Lanczos a3;
        RealMatrix a4 = new RealMatrix(a3.n, 1);
        BigDecimal a5 = BigDecimalUtils.exp(1.0, a3.scale);
        BigDecimal a6 = BigDecimalUtils.pow(BigDecimal.valueOf(2L), BigDecimal.valueOf(0.5), a3.scale);
        int n = a2 = 0;
        while (n < a3.n) {
            double[] dArray = new double[2];
            dArray[0] = a3.g;
            dArray[1] = a2;
            BigDecimal a7 = BigDecimal.valueOf(2L).multiply(BigDecimalUtils.sum(dArray)).add(BigDecimal.ONE);
            BigDecimal a8 = a5.divide(a7, a3.scale, 6);
            double[] dArray2 = new double[2];
            dArray2[0] = 0.5;
            dArray2[1] = a2;
            a8 = BigDecimalUtils.pow(a8, BigDecimalUtils.sum(dArray2), a3.scale);
            a8 = a6.multiply(a8);
            a4.set(a2 + 1, 1, new Real(a8));
            n = ++a2;
        }
        return a4;
    }

    private RealMatrix M() {
        int a2;
        Lanczos a3;
        RealMatrix a4 = new RealMatrix(a3.n, a3.n);
        int n = a2 = 0;
        while (n < a3.n) {
            a4.set(1, a2 + 1, Real.ONE);
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 < a3.n) {
            int a5 = 1;
            int n3 = a2;
            while (n3 < a3.n) {
                int a6;
                Real a7 = new Real(BigIntegerUtils.combination(a2 + a6 - 1, a6 - a2));
                a4.set(a2 + 1, a6 + 1, (Real)(a5 == 1 ? a7 : a7.opposite()));
                a5 *= -1;
                n3 = ++a6;
            }
            n2 = ++a2;
        }
        return a4;
    }

    double logGamma(double a2) {
        Lanczos a3;
        return a3.logGamma(BigDecimal.valueOf(a2)).doubleValue();
    }

    BigDecimal logGamma(BigDecimal a2) {
        Lanczos a3;
        BigDecimal a4 = a2.add(BigDecimal.valueOf(-1L));
        RealMatrix a5 = a3.Z(a4).multiply(a3.P);
        double[] dArray = new double[2];
        dArray[0] = a3.g;
        dArray[1] = 0.5;
        BigDecimal a6 = a4.add(BigDecimalUtils.sum(dArray));
        BigDecimal a7 = BigDecimalUtils.log(a5.get(1, 1).bigDecimal(), a3.scale);
        BigDecimal a8 = a4.add(BigDecimal.valueOf(0.5)).multiply(BigDecimalUtils.log(a6));
        BigDecimal a9 = a6.negate();
        BigDecimal a10 = a7.add(a8).add(a9);
        return a10;
    }

    private Real i() {
        Lanczos a2;
        BigDecimal a3 = BigDecimalUtils.exp(a2.g, a2.scale);
        BigDecimal a4 = BigDecimalUtils.pow(BigDecimalUtils.PI.multiply(new BigDecimal(b.C("g"))), new BigDecimal(b.C("&9`")), a2.scale);
        BigDecimal a5 = a3.divide(a4, a2.scale, 6);
        return new Real(a5);
    }

    Lanczos(double a2, int a3, int a4) {
        Lanczos a5;
        a5.g = a2;
        a5.n = a3;
        a5.scale = a4;
        a5.B = a5.M();
        a5.C = a5.C();
        a5.D = a5.h();
        a5.F = a5.H();
        a5.P = a5.e();
        a5.P4double = a5.P.doubleValue();
    }

    double logGammaQuick(double a2) {
        Lanczos a3;
        double a4 = a2 - 1.0;
        DenseMatrix a5 = a3.getZ(a4).multiply(a3.P4double);
        double a6 = a4 + a3.g + 0.5;
        double a7 = Math.log(a5.get(1, 1));
        double a8 = (a4 + 0.5) * Math.log(a6);
        double a9 = -a6;
        double a10 = a7 + a8 + a9;
        return a10;
    }

    Lanczos() {
        Lanczos a2;
        a2.g = 4.7421875;
        a2.n = 15;
        a2.scale = 30;
        a2.B = null;
        a2.C = null;
        a2.D = null;
        a2.F = null;
        double[][] dArrayArray = new double[15][];
        double[] dArray = new double[1];
        dArray[0] = 2.506628274630993;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[1];
        dArray2[0] = 143.26943639152483;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[1];
        dArray3[0] = -149.3899325373723;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[1];
        dArray4[0] = 35.433942876441684;
        dArrayArray[3] = dArray4;
        double[] dArray5 = new double[1];
        dArray5[0] = -1.233045080111929;
        dArrayArray[4] = dArray5;
        double[] dArray6 = new double[1];
        dArray6[0] = 8.521195083811379E-5;
        dArrayArray[5] = dArray6;
        double[] dArray7 = new double[1];
        dArray7[0] = 1.1661744370698067E-4;
        dArrayArray[6] = dArray7;
        double[] dArray8 = new double[1];
        dArray8[0] = -2.465882413012002E-4;
        dArrayArray[7] = dArray8;
        double[] dArray9 = new double[1];
        dArray9[0] = 3.9626961340331467E-4;
        dArrayArray[8] = dArray9;
        double[] dArray10 = new double[1];
        dArray10[0] = -5.270547947751436E-4;
        dArrayArray[9] = dArray10;
        double[] dArray11 = new double[1];
        dArray11[0] = 5.450402947925591E-4;
        dArrayArray[10] = dArray11;
        double[] dArray12 = new double[1];
        dArray12[0] = -4.1188441187888137E-4;
        dArrayArray[11] = dArray12;
        double[] dArray13 = new double[1];
        dArray13[0] = 2.1160510713205815E-4;
        dArrayArray[12] = dArray13;
        double[] dArray14 = new double[1];
        dArray14[0] = -6.565069607369536E-5;
        dArrayArray[13] = dArray14;
        double[] dArray15 = new double[1];
        dArray15[0] = 9.24925345651559E-6;
        dArrayArray[14] = dArray15;
        a2.P = new RealMatrix(dArrayArray);
        double[][] dArrayArray2 = new double[15][];
        double[] dArray16 = new double[1];
        dArray16[0] = 2.506628274630993;
        dArrayArray2[0] = dArray16;
        double[] dArray17 = new double[1];
        dArray17[0] = 143.26943639152483;
        dArrayArray2[1] = dArray17;
        double[] dArray18 = new double[1];
        dArray18[0] = -149.3899325373723;
        dArrayArray2[2] = dArray18;
        double[] dArray19 = new double[1];
        dArray19[0] = 35.433942876441684;
        dArrayArray2[3] = dArray19;
        double[] dArray20 = new double[1];
        dArray20[0] = -1.233045080111929;
        dArrayArray2[4] = dArray20;
        double[] dArray21 = new double[1];
        dArray21[0] = 8.521195083811379E-5;
        dArrayArray2[5] = dArray21;
        double[] dArray22 = new double[1];
        dArray22[0] = 1.1661744370698067E-4;
        dArrayArray2[6] = dArray22;
        double[] dArray23 = new double[1];
        dArray23[0] = -2.465882413012002E-4;
        dArrayArray2[7] = dArray23;
        double[] dArray24 = new double[1];
        dArray24[0] = 3.9626961340331467E-4;
        dArrayArray2[8] = dArray24;
        double[] dArray25 = new double[1];
        dArray25[0] = -5.270547947751436E-4;
        dArrayArray2[9] = dArray25;
        double[] dArray26 = new double[1];
        dArray26[0] = 5.450402947925591E-4;
        dArrayArray2[10] = dArray26;
        double[] dArray27 = new double[1];
        dArray27[0] = -4.1188441187888137E-4;
        dArrayArray2[11] = dArray27;
        double[] dArray28 = new double[1];
        dArray28[0] = 2.1160510713205815E-4;
        dArrayArray2[12] = dArray28;
        double[] dArray29 = new double[1];
        dArray29[0] = -6.565069607369536E-5;
        dArrayArray2[13] = dArray29;
        double[] dArray30 = new double[1];
        dArray30[0] = 9.24925345651559E-6;
        dArrayArray2[14] = dArray30;
        a2.P4double = new DenseMatrix(dArrayArray2);
    }

    private RealMatrix h() {
        int a2;
        Lanczos a3;
        RealMatrix a4 = new RealMatrix(a3.n, a3.n);
        a4.set(1, 1, Real.ONE);
        a4.set(2, 2, (Real)Real.ONE.opposite());
        int n = a2 = 2;
        while (n < a3.n) {
            Real a5 = a4.get(a2, a2);
            a5 = a5.multiply(new Real(2 * (2 * a2 - 1)));
            a5 = a5.divide(new Real(a2 - 1), a3.scale);
            a4.set(a2 + 1, a2 + 1, a5);
            n = ++a2;
        }
        return a4;
    }

    private RealMatrix e() {
        Lanczos a2;
        RealMatrix a3 = a2.D.multiply(a2.B);
        a3 = a3.multiply(a2.C);
        a3 = a3.multiply(a2.F);
        return a3;
    }

    DenseMatrix getZ(double a2) {
        int a3;
        Lanczos a4;
        DenseMatrix a5 = new DenseMatrix(1, a4.n);
        a5.set(1, 1, 1.0);
        int n = a3 = 1;
        while (n < a4.n) {
            double a6 = 1.0 / ((double)a3 + a2);
            a5.set(1, a3 + 1, a6);
            n = ++a3;
        }
        return a5;
    }

    private RealMatrix C() {
        int a2;
        Lanczos a3;
        RealMatrix a4 = new RealMatrix(a3.n, a3.n);
        a4.set(1, 1, new Real(b.C("&9`")));
        int n = a2 = 1;
        while (n < a3.n) {
            int a5;
            int a6 = a2 % 2 == 1 ? -1 : 1;
            int n2 = a5 = 0;
            while (n2 <= a2) {
                int a7;
                BigInteger a8 = BigInteger.ZERO;
                int n3 = a7 = 0;
                while (n3 <= a2) {
                    BigInteger a9 = BigIntegerUtils.combination(2 * a2, 2 * a7);
                    BigInteger a10 = a7 + a5 - a2 >= 0 ? BigIntegerUtils.combination(a7, a7 + a5 - a2) : BigInteger.ZERO;
                    BigInteger a11 = a9.multiply(a10);
                    a8 = a8.add(a11);
                    n3 = ++a7;
                }
                a4.set(a2 + 1, a5 + 1, a6 > 0 ? new Real(a8) : new Real(a8.negate()));
                a6 *= -1;
                n2 = ++a5;
            }
            n = ++a2;
        }
        return a4;
    }

    private RealMatrix H() {
        int a2;
        Lanczos a3;
        RealMatrix a4 = new RealMatrix(a3.n, 1);
        int n = a2 = 0;
        while (n < a3.n) {
            BigDecimal a5 = BigDecimal.valueOf(2L);
            int n2 = a2 + 1;
            while (true) {
                int a6;
                if (n2 > 2 * a2) break;
                a5 = a5.multiply(BigDecimal.valueOf(a6));
                a5 = a5.divide(BigDecimal.valueOf(4L), a3.scale, 6);
                n2 = ++a6;
            }
            double[] dArray = new double[3];
            dArray[0] = a2;
            dArray[1] = a3.g;
            dArray[2] = 0.5;
            a5 = a5.multiply(BigDecimalUtils.exp(BigDecimalUtils.sum(dArray), a3.scale));
            double[] dArray2 = new double[3];
            dArray2[0] = a2;
            dArray2[1] = a3.g;
            dArray2[2] = 0.5;
            double[] dArray3 = new double[2];
            dArray3[0] = a2;
            dArray3[1] = 0.5;
            a5 = a5.divide(BigDecimalUtils.pow(BigDecimalUtils.sum(dArray2), BigDecimalUtils.sum(dArray3), a3.scale), a3.scale, 6);
            a4.set(a2 + 1, 1, new Real(a5));
            n = ++a2;
        }
        return a4;
    }
}

