/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.Lanczos;

public class LogGamma
extends UnivariateRealFunction {
    private Method m;
    private final Lanczos H;

    public LogGamma() {
        this.m = Method.LANCZOS_QUICK;
        this.H = new Lanczos();
    }

    public double evaluate(double x2) {
        double a2 = Double.NaN;
        double a3 = x2 > 0.0 ? x2 : -x2;
        switch (this.m) {
            case LANCZOS_QUICK: {
                do {
                } while (false);
                a2 = this.H.logGammaQuick(a3);
                break;
            }
            default: {
                a2 = this.H.logGamma(a3);
            }
        }
        return a2;
    }

    public LogGamma(Method method, double g2, int n, int scale) {
        this.m = method;
        this.H = new Lanczos(g2, n, scale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LANCZOS_QUICK;
        public static final /* enum */ Method LANCZOS;
        private static final /* synthetic */ Method[] $VALUES;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            LANCZOS = new Method();
            LANCZOS_QUICK = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = LANCZOS;
            methodArray[1] = LANCZOS_QUICK;
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

