/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class EulerMaclaurin
implements IterativeIntegrator {
    public final double precision;
    public final int maxIterations;
    public final int rate;
    private double m;
    private int H = 1;
    public final NewtonCotesType type;

    public double h() {
        return this.m;
    }

    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        int a3;
        double a4 = Double.NaN;
        double a5 = Double.NaN;
        int n = a3 = 1;
        while (n <= this.maxIterations) {
            a4 = a5;
            a5 = this.next(a3, f, a2, b2, a4);
            if (a3 > 3 && DoubleUtils.relativeError(a5, a4) < this.precision) break;
            n = ++a3;
        }
        return a5;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public EulerMaclaurin(int rate, NewtonCotesType type, double precision, int maxIterations) {
        this.rate = rate;
        this.type = type;
        this.precision = precision;
        this.maxIterations = maxIterations;
    }

    public double next(int iter, UnivariateRealFunction f, double a2, double b2, double sum0) {
        SuanShuUtils.assertArgument(iter > 0, b.C("g{h|k{`ah/fawau.sznz:m|.=y0"));
        double a3 = sum0;
        if (iter == 1) {
            this.m = b2 - a2;
            this.H = 1;
            switch (this.type) {
                case CLOSED: {
                    a3 = 0.5 * this.m * (f.evaluate(a2) + f.evaluate(b2));
                    break;
                }
                case OPEN: {
                    do {
                    } while (false);
                    a3 = this.m * f.evaluate((a2 + b2) / 2.0);
                }
            }
        } else {
            int a4;
            this.m /= (double)this.rate;
            this.H *= this.rate;
            double a5 = 0.0;
            double a6 = a2;
            int n = a4 = 1;
            while (n < this.H) {
                a6 += this.m;
                if (a4 % this.rate != 0) {
                    a5 += f.evaluate(a6);
                }
                n = ++a4;
            }
            a3 = sum0 / (double)this.rate + this.m * a5;
        }
        return a3;
    }

    public double precision() {
        return this.precision;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NewtonCotesType
    extends Enum<NewtonCotesType> {
        public static final /* enum */ NewtonCotesType OPEN;
        public static final /* enum */ NewtonCotesType CLOSED;
        private static final /* synthetic */ NewtonCotesType[] $VALUES;

        public static NewtonCotesType valueOf(String name) {
            return Enum.valueOf(NewtonCotesType.class, name);
        }

        public static NewtonCotesType[] values() {
            return (NewtonCotesType[])$VALUES.clone();
        }

        private NewtonCotesType() {
            NewtonCotesType a2;
        }

        static {
            CLOSED = new NewtonCotesType();
            OPEN = new NewtonCotesType();
            NewtonCotesType[] newtonCotesTypeArray = new NewtonCotesType[2];
            newtonCotesTypeArray[0] = CLOSED;
            newtonCotesTypeArray[1] = OPEN;
            $VALUES = newtonCotesTypeArray;
        }
    }
}

