/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Integrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.analysis.interpolation.NevilleTable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Romberg
implements Integrator {
    private IterativeIntegrator m;
    private final NevilleTable H;

    private double H(double a2, double a3) {
        Romberg a4;
        double[] dArray = new double[1];
        dArray[0] = a2;
        double[] dArray2 = new double[1];
        dArray2[0] = a3;
        a4.H.addData(dArray, dArray2);
        int a5 = a4.H.N();
        double a6 = Double.NaN;
        if (a5 >= 2) {
            a6 = a4.H.evaluate(0.0);
        }
        return a6;
    }

    public double precision() {
        return this.m.precision();
    }

    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        int a3;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        int n = a3 = 1;
        while (n <= this.m.maxIterations()) {
            a4 = this.m.next(a3, f, a2, b2, a4);
            double a7 = this.m.h();
            a6 = this.H(a7, a4);
            a5 = this.H();
            if (a3 > 3 && DoubleUtils.relativeError(a6, a5) < this.precision()) break;
            n = ++a3;
        }
        return a6;
    }

    public Romberg(IterativeIntegrator integrator) {
        SuanShuUtils.assertArgument(integrator.maxIterations() >= 2, b.C("`}r4~`~vyg?{~5r`agf`izmg,xzg|5iq\u0014+\u0017&\u0010s\\f\u001cpG`JtK{HtS}O;"));
        this.m = integrator;
        this.H = new NevilleTable();
    }

    private double H() {
        Romberg a2;
        int a3 = a2.H.N();
        double a4 = Double.NaN;
        if (a3 >= 2) {
            a4 = a2.H.get(0, a3 - 2);
        }
        return a4;
    }
}

