/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Trapezoidal;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Simpson
implements IterativeIntegrator {
    public final int maxIterations;
    private double M;
    private double m;
    private Trapezoidal H;
    public final double precision;

    public int maxIterations() {
        return this.maxIterations;
    }

    public double h() {
        return this.H.h();
    }

    public Simpson(double precision, int maxIterations) {
        this.H = new Trapezoidal(precision, maxIterations);
        this.maxIterations = maxIterations;
        this.precision = precision;
    }

    public double precision() {
        return this.precision;
    }

    public double next(int iteration, UnivariateRealFunction f, double a2, double b2, double sum) {
        if (iteration == 1) {
            this.m = this.H.next(1, f, a2, b2, sum);
            this.M = this.H.next(2, f, a2, b2, this.m);
        } else {
            this.m = this.M;
            this.M = this.H.next(iteration + 1, f, a2, b2, this.m);
        }
        return (4.0 * this.M - this.m) / 3.0;
    }

    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        int a3;
        double a4 = Double.NaN;
        double a5 = Double.NaN;
        int n = a3 = 1;
        while (n <= this.maxIterations) {
            a4 = a5;
            a5 = this.next(a3, f, a2, b2, a4);
            if (a3 > 3 && DoubleUtils.relativeError(a5, a4) < this.precision) break;
            n = ++a3;
        }
        return a5;
    }
}

