/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class DoubleExponential
extends Substitution {
    public final double a;
    private double H = 0.001;
    public final double c;
    public final UnivariateRealFunction f;
    public final double b;

    DoubleExponential(UnivariateRealFunction a2, UnivariateRealFunction a3, UnivariateRealFunction a4, double a5, double a6, double a7) {
        super(a2, a3);
        DoubleExponential a8;
        a8.a = a6;
        a8.b = a7;
        a8.c = a5;
        a8.f = a4;
    }

    public double tb() {
        double a2 = 4.3;
        if (this.f != null) {
            double a3 = Double.NaN;
            while (Double.isInfinite(a3 = this.H(a2 -= this.H)) || Double.isNaN(a3)) {
            }
        }
        return a2;
    }

    private static UnivariateRealFunction C(double a2, final double a3, final double a4) {
        return new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double t2) {
                double a2 = Math.exp(-2.0 * Math.sinh(t2));
                return 2.0 * (a4 - a3) * a2 / (1.0 + a2) / (1.0 + a2) * Math.cosh(t2);
            }
        };
    }

    public DoubleExponential(UnivariateRealFunction f, double c2, double a2, double b2) {
        this(DoubleExponential.H(c2, a2, b2), DoubleExponential.C(c2, a2, b2), f, c2, a2, b2);
    }

    private double H(double a2) {
        DoubleExponential a3;
        double a4 = a3.x.evaluate(a2);
        double a5 = a3.dx.evaluate(a2);
        double a6 = a3.f.evaluate(a4) * a5;
        return a6;
    }

    public double ta() {
        double a2 = -4.3;
        if (this.f != null) {
            double a3 = Double.NaN;
            while (Double.isInfinite(a3 = this.H(a2 += this.H)) || Double.isNaN(a3)) {
            }
        }
        return a2;
    }

    private static UnivariateRealFunction H(final double a2, final double a3, final double a4) {
        return new UnivariateRealFunction(){
            {
                1 a22;
            }

            public double evaluate(double t2) {
                return 0.5 * (a4 + a3) + 0.5 * (a4 - a3) * Math.tanh(a2 * Math.sinh(t2));
            }
        };
    }
}

