/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class Exponential
extends Substitution {
    public final double a;
    public final double b;

    public Exponential(double a2, double b2) {
        super(new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double t2) {
                return -Math.log(t2);
            }
        }, new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double t2) {
                return 1.0 / t2;
            }
        });
        this.a = a2;
        this.b = b2;
    }

    public double tb() {
        return Math.exp(-this.a);
    }

    public double ta() {
        return 0.0;
    }
}

