/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class PowerLawSingularity
extends Substitution {
    public final Type type;
    public final double gamma;
    public final double b;
    public final double a;

    public double ta() {
        return 0.0;
    }

    public PowerLawSingularity(final Type type, final double gamma, final double a2, final double b2) {
        super(new UnivariateRealFunction(){
            {
                1 a22;
            }

            public double evaluate(double t2) {
                switch (type) {
                    case LOWER: {
                        return Math.pow(t2, 1.0 / (1.0 - gamma)) + a2;
                    }
                    case UPPER: {
                        do {
                        } while (false);
                        return b2 - Math.pow(t2, 1.0 / (1.0 - gamma));
                    }
                }
                throw new IllegalArgumentException(b.C("|fxlngighrgm%{og~}vhoajp1|ky0"));
            }
        }, new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double t2) {
                return Math.pow(t2, gamma / (1.0 - gamma)) / (1.0 - gamma);
            }
        });
        this.type = type;
        this.gamma = gamma;
        this.a = a2;
        this.b = b2;
    }

    public double tb() {
        return Math.pow(this.b - this.a, 1.0 - this.gamma);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UPPER = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type LOWER = new Type();

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            Type[] typeArray = new Type[2];
            typeArray[0] = UPPER;
            typeArray[1] = LOWER;
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        private Type() {
            Type a2;
        }
    }
}

