/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.interpolation;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.interpolation.UnivariateRealInterpolator;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class NevilleTable
extends UnivariateRealFunction
implements UnivariateRealInterpolator {
    private double F;
    private static final double B = 1.2;
    private double[] G;
    private int M;
    private double[][] m;
    private int H;

    public NevilleTable(double[] x2, double[] y2) {
        this(0, x2, y2);
    }

    public int N() {
        return this.H;
    }

    public void addData(double[] x2, double[] y2) {
        int a2;
        int a3;
        int a4 = x2.length;
        if (this.H + a4 > this.m.length) {
            int a5;
            int a6;
            a3 = (int)((double)(this.H + a4) * 1.2);
            double[] a7 = new double[a3];
            int n = a6 = 0;
            while (n < this.H) {
                a7[a6] = this.G[a6];
                n = ++a6;
            }
            this.G = a7;
            double[][] a22 = new double[a3][a3];
            int n2 = a5 = 0;
            while (n2 < this.H) {
                int n3 = a5;
                while (n3 < this.H) {
                    int a8;
                    a22[a5][a8] = this.m[a5][a8];
                    n3 = ++a8;
                }
                n2 = ++a5;
            }
            this.m = a22;
        }
        a3 = this.H;
        int n = a2 = 0;
        while (n < a4) {
            this.G[a3] = x2[a2];
            this.m[a3][a3] = y2[a2];
            ++a3;
            n = ++a2;
        }
        this.H += a4;
    }

    public double[] X() {
        int a2;
        double[] a3 = new double[this.H];
        int n = a2 = 0;
        while (n < this.H) {
            a3[a2] = this.G[a2];
            n = ++a2;
        }
        return a3;
    }

    public double[][] table() {
        int a2;
        double[][] a3 = new double[this.H][this.H];
        int n = a2 = 0;
        while (n < this.H) {
            int n2 = a2;
            while (n2 < this.H) {
                int a4;
                a3[a2][a4] = this.m[a2][a4];
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public NevilleTable() {
        int a2 = 10;
        this.m = new double[a2][a2];
        this.G = new double[a2];
        this.H = 0;
    }

    public NevilleTable(int n, double[] x2, double[] y2) {
        SuanShuUtils.assertArgument(x2.length == y2.length, b.C("fbuc&plxop)fa#cmf#|cb`="));
        int a2 = n;
        if (a2 < x2.length) {
            a2 = (int)((double)x2.length * 1.2);
        }
        this.G = new double[a2];
        this.m = new double[a2][a2];
        this.addData(x2, y2);
    }

    public double get(int row, int col) {
        SuanShuUtils.assertArgument(col >= row, b.C("III_\u0002SIC\u000eR]VOU\tRDNTHUR]GL\u0007MGHS\u0019I`\u0007qNg\u0007uGlKh\u0006cT)SeB1"));
        return this.m[row][col];
    }

    public double evaluate(double x2) {
        int a2;
        SuanShuUtils.assertArgument(this.H >= 2, b.C("{{b5tz}`z|>qx`{5u{o{ug\"sbf.|g`ogE{ZtE}];"));
        if (this.M == this.H - 1 && this.F == x2) {
            return this.m[0][this.M];
        }
        int n = a2 = this.F == x2 ? this.M : 1;
        while (n < this.H) {
            int n2 = a2 - 1;
            while (n2 >= 0) {
                int a3;
                double a4 = (x2 - this.G[a2]) * this.m[a3][a2 - 1];
                a4 += (this.G[a3] - x2) * this.m[a3 + 1][a2];
                double a5 = this.G[a3] - this.G[a2];
                if (DoubleUtils.compare(a5, 0.0) == 0) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = a3;
                    objectArray[1] = a2;
                    throw new DuplicatedAbscissae(String.format(b.C("qS/mP(oge(zR l[)xz\u007f)tl{geaqh9"), objectArray));
                }
                this.m[a3][a2] = a4 /= a5;
                n2 = --a3;
            }
            n = ++a2;
        }
        this.F = x2;
        this.M = this.H - 1;
        return this.m[0][this.M];
    }

    public static class DuplicatedAbscissae
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DuplicatedAbscissae(String msg) {
            super(msg);
        }
    }
}

