/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.uniroot;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;

public abstract class Uniroot {
    public final UnivariateRealFunction f;
    public final double tol;

    public Uniroot(UnivariateRealFunction f, double tol) {
        this.f = f;
        this.tol = tol;
    }

    public abstract double solve(int var1, double var2, double var4, double ... var6);

    public double solve(int maxIterations, double lower, double upper, double guess) throws NoRootFoundException {
        double d2;
        double d3;
        double[] dArray = new double[1];
        dArray[0] = guess;
        double a2 = this.solve(maxIterations, lower, upper, dArray);
        if (d3 < lower) {
            a2 = lower;
        }
        if (a2 > upper) {
            a2 = upper;
        }
        double a3 = this.f.evaluate(a2);
        if (Math.abs(d2) > this.tol) {
            throw new NoRootFoundException(a2, a3);
        }
        return a2;
    }

    public static class NoRootFoundException
    extends Exception {
        public final double x;
        private static final long serialVersionUID = 1L;
        public final double fx;

        public NoRootFoundException(double x2, double fx) {
            Object[] objectArray = new Object[2];
            objectArray[0] = x2;
            objectArray[1] = fx;
            super(String.format(b.C("TT\u0019HQTI\u001aTTDTR\u0000\u0015XOH]\u001aOK]HMC\u000f\u001aTTJN:Rj\u001a;]&\u001at\u0013i\u0013+\u001e3"), objectArray));
            this.x = x2;
            this.fx = fx;
        }
    }
}

