/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.datastructure;

import com.numericalmethod.suanshu.Constant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathTable {
    private final double M = 10.0 * Constant.EPSILON;
    private final TreeMap<Double, Row> m;
    private final Map<String, Integer> H = new HashMap<String, Integer>();

    public double get(double rowValue, String header) {
        return this.get(rowValue, this.H.get(header));
    }

    public int nColumns() {
        return this.H.size();
    }

    public Iterator<Row> getRowsOnOrBefore(double rowValue) {
        NavigableMap<Double, Row> a2 = this.m.headMap(rowValue + this.M, true).descendingMap();
        Collection a3 = a2.values();
        return a3.iterator();
    }

    public MathTable(int nColumns) {
        int a2;
        this.m = new TreeMap();
        String[] a3 = new String[nColumns];
        int n = a2 = 1;
        while (n <= nColumns) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            a3[a2 - 1] = String.format(b.C("V{z`|z71"), objectArray);
            n = ++a2;
        }
        this.H(a3);
    }

    public String[] headers() {
        Iterator<String> a2;
        String[] a3 = new String[this.nColumns()];
        Set<String> a4 = this.H.keySet();
        Iterator<String> iterator = a2 = a4.iterator();
        while (iterator.hasNext()) {
            String a5 = a2.next();
            Integer a6 = this.H.get(a5);
            a3[a6.intValue()] = a5;
            iterator = a2;
        }
        return a3;
    }

    public Iterator<Row> getRowsOnOrAfter(double rowValue) {
        Collection a2 = this.m.tailMap(rowValue - this.M, true).values();
        return a2.iterator();
    }

    private void H(String[] a2) {
        MathTable a3;
        int a4;
        int a5 = 0;
        String[] a6 = a2;
        int a7 = a2.length;
        int n = a4 = 0;
        while (n < a7) {
            String a8 = a6[a4];
            a3.H.put(a8, a5++);
            n = ++a4;
        }
        if (a3.H.size() < a2.length) {
            throw new RuntimeException(b.C("p`gxyvr`yq?|}t\u007fqv&"));
        }
    }

    public MathTable(String ... headers) {
        this.m = new TreeMap();
        this.H(headers);
    }

    public Row getRowOnOrBefore(double rowValue) {
        double a2 = this.m.headMap(rowValue + this.M).lastKey();
        return this.m.get(a2);
    }

    public double get(double rowValue, int columnIndex) {
        Row a2 = this.getRowOnOrBefore(rowValue);
        double a3 = a2.index;
        double a4 = a2.get(columnIndex);
        if (a3 == rowValue) {
            return a4;
        }
        Row a5 = this.getRowOnOrAfter(rowValue);
        double a6 = a5.index;
        double a7 = a5.get(columnIndex);
        double a8 = a4 * (a6 - rowValue);
        a8 += a7 * (rowValue - a3);
        return a8 /= a6 - a3;
    }

    public double[] keys() {
        Iterator<Double> a2;
        NavigableSet<Double> a3 = this.m.navigableKeySet();
        double[] a4 = new double[a3.size()];
        int a5 = 0;
        Iterator<Double> iterator = a2 = a3.iterator();
        while (iterator.hasNext()) {
            a4[a5++] = a2.next();
            iterator = a2;
        }
        return a4;
    }

    public Row getRowOnOrAfter(double rowValue) {
        double a2 = this.m.tailMap(rowValue - this.M).firstKey();
        return this.m.get(a2);
    }

    public void addRows(double[][] data) {
        int a2;
        int n = a2 = 0;
        while (n < data.length) {
            double[] a3 = data[a2];
            double a4 = a3[0];
            double[] a5 = Arrays.copyOfRange(a3, 1, a3.length);
            this.addRow(a4, a5);
            n = ++a2;
        }
    }

    public void addRow(double rowValue, double[] columnValues) {
        Row a2 = new Row(rowValue, columnValues);
        this.m.put(a2.index, a2);
    }

    public class Row {
        public final double index;
        private final double[] H;

        public double get(int columnIndex) {
            return this.H[columnIndex - 1];
        }

        public double get(String header) {
            return this.get((Integer)MathTable.this.H.get(header));
        }

        private Row(double a2, double[] a3) {
            Row a4;
            a4.index = a2;
            a4.H = Arrays.copyOf(a3, a3.length);
        }

        public double[] toArray() {
            return Arrays.copyOf(this.H, this.H.length);
        }
    }
}

