/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.interval;

import com.numericalmethod.suanshu.interval.Interval;

public interface Algebra {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Relation
    extends Enum<Relation> {
        public static final /* enum */ Relation DURING_INVERSE;
        public static final /* enum */ Relation MEET;
        public static final /* enum */ Relation START;
        public static final /* enum */ Relation EQUAL;
        public static final /* enum */ Relation OVERLAP_INVERSE;
        public static final /* enum */ Relation BEFORE;
        public static final /* enum */ Relation FINISH_INVERSE;
        public static final /* enum */ Relation MEET_INVERSE;
        public static final /* enum */ Relation OVERLAP;
        public static final /* enum */ Relation AFTER;
        private static final /* synthetic */ Relation[] $VALUES;
        public static final /* enum */ Relation START_INVERSE;
        public static final /* enum */ Relation DURING;
        public static final /* enum */ Relation FINISH;

        public abstract <T extends Comparable<T>> boolean isRelationBetween(Interval<T> var1, Interval<T> var2);

        public static Relation valueOf(String name) {
            return Enum.valueOf(Relation.class, name);
        }

        public static Relation[] values() {
            return (Relation[])$VALUES.clone();
        }

        private Relation() {
            Relation a2;
        }

        static {
            BEFORE = new Relation(){
                {
                    1 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.end.compareTo(y2.begin) < 0;
                }
            };
            AFTER = new Relation(){
                {
                    2 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.end) > 0;
                }
            };
            MEET = new Relation(){
                {
                    3 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.end.compareTo(y2.begin) == 0;
                }
            };
            MEET_INVERSE = new Relation(){
                {
                    4 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return y2.end.compareTo(x2.begin) == 0;
                }
            };
            OVERLAP = new Relation(){
                {
                    5 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return y2.begin.compareTo(x2.begin) > 0 && y2.begin.compareTo(x2.end) < 0 && y2.end.compareTo(x2.end) > 0;
                }
            };
            OVERLAP_INVERSE = new Relation(){
                {
                    6 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.end.compareTo(y2.end) > 0 && x2.begin.compareTo(y2.begin) > 0 && x2.begin.compareTo(y2.end) < 0;
                }
            };
            START = new Relation(){
                {
                    7 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) == 0 && x2.end.compareTo(y2.end) < 0;
                }
            };
            START_INVERSE = new Relation(){
                {
                    8 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) == 0 && x2.end.compareTo(y2.end) > 0;
                }
            };
            DURING = new Relation(){
                {
                    9 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) > 0 && x2.end.compareTo(y2.end) < 0;
                }
            };
            DURING_INVERSE = new Relation(){
                {
                    10 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) < 0 && x2.end.compareTo(y2.end) > 0;
                }
            };
            FINISH = new Relation(){
                {
                    11 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) > 0 && x2.end.compareTo(y2.end) == 0;
                }
            };
            FINISH_INVERSE = new Relation(){
                {
                    12 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) < 0 && x2.end.compareTo(y2.end) == 0;
                }
            };
            EQUAL = new Relation(){
                {
                    13 a2;
                }

                @Override
                public <T extends Comparable<T>> boolean isRelationBetween(Interval<T> x2, Interval<T> y2) {
                    return x2.begin.compareTo(y2.begin) == 0 && x2.end.compareTo(y2.end) == 0;
                }
            };
            Relation[] relationArray = new Relation[13];
            relationArray[0] = BEFORE;
            relationArray[1] = AFTER;
            relationArray[2] = MEET;
            relationArray[3] = MEET_INVERSE;
            relationArray[4] = OVERLAP;
            relationArray[5] = OVERLAP_INVERSE;
            relationArray[6] = START;
            relationArray[7] = START_INVERSE;
            relationArray[8] = DURING;
            relationArray[9] = DURING_INVERSE;
            relationArray[10] = FINISH;
            relationArray[11] = FINISH_INVERSE;
            relationArray[12] = EQUAL;
            $VALUES = relationArray;
        }
    }
}

