/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class AreMatrices {
    public static boolean equal(Vector v1, Vector v2, double epsilon) {
        int a2;
        if (v1.size() != v2.size()) {
            return false;
        }
        int n = a2 = 1;
        while (n <= v1.size()) {
            if (DoubleUtils.compare(v1.get(a2), v2.get(a2), epsilon) != 0) {
                return false;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean equal(Matrix A1, Matrix A2, double epsilon) {
        boolean a2 = true;
        if (!DimensionCheck.sameDimension(A1, A2)) {
            a2 = false;
        } else {
            int a3;
            int n = a3 = 1;
            block0: while (n <= A1.nRows()) {
                int a4;
                int n2 = a4 = 1;
                while (n2 <= A1.nCols()) {
                    if (DoubleUtils.compare(A1.get(a3, a4), A2.get(a3, a4), epsilon) != 0) {
                        a2 = false;
                        break block0;
                    }
                    n2 = ++a4;
                }
                n = ++a3;
            }
        }
        return a2;
    }

    public static boolean orthogonormal(Vector v1, Vector v2, double epsilon) {
        return DoubleUtils.compare(0.0, v1.innerProduct(v2), epsilon) == 0 && DoubleUtils.compare(1.0, v1.norm(), epsilon) == 0 && DoubleUtils.compare(1.0, v2.norm(), epsilon) == 0;
    }

    public static boolean orthogonormal(Vector[] v, double epsilon) {
        int a2;
        boolean a3 = true;
        int n = a2 = 0;
        while (n < v.length) {
            int n2 = a2 + 1;
            while (n2 < v.length) {
                int a4;
                a3 = AreMatrices.orthogonormal(v[a2], v[a4], epsilon);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static boolean orthogonal(Vector[] v, double epsilon) {
        int a2;
        boolean a3 = true;
        int n = a2 = 0;
        while (n < v.length) {
            int n2 = a2 + 1;
            while (n2 < v.length) {
                int a4;
                a3 = DoubleUtils.compare(0.0, v[a2].innerProduct(v[a4]), epsilon) == 0;
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    private AreMatrices() {
        AreMatrices a2;
    }

    public static boolean orthogonal(Vector v1, Vector v2, double epsilon) {
        return DoubleUtils.compare(0.0, v1.innerProduct(v2), epsilon) == 0;
    }
}

