/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Hessenberg;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Cholesky;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.TriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Measure;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class IsMatrix {
    public static boolean lowerBidiagonal(Matrix A, double epsilon) {
        int a2;
        int a3;
        int n = a3 = 1;
        while (n <= A.nRows()) {
            int n2 = a2 = 1;
            int n3 = a3;
            while (true) {
                if (n2 > n3 - 2 || a2 > A.nCols()) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n2 = ++a2;
                n3 = a3;
            }
            n = ++a3;
        }
        int n4 = a3 = 1;
        while (n4 <= A.nRows()) {
            int n5 = A.nCols();
            while (true) {
                if (n5 < a3 + 1) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n5 = --a2;
            }
            n4 = ++a3;
        }
        return true;
    }

    public static boolean symmetricPositiveDefinite(Matrix A) {
        try {
            Cholesky a2 = new Cholesky(A);
            LowerTriangularMatrix lowerTriangularMatrix = a2.L();
        }
        catch (RuntimeException a3) {
            return false;
        }
        return true;
    }

    public static boolean upperBidiagonal(Matrix A, double epsilon) {
        int a2;
        int a3;
        int n = a3 = 1;
        while (n <= A.nRows()) {
            int n2 = A.nCols();
            while (true) {
                if (n2 < a3 + 2) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n2 = --a2;
            }
            n = ++a3;
        }
        int n3 = a3 = 1;
        while (n3 <= A.nRows()) {
            int n4 = a2 = 1;
            int n5 = a3;
            while (true) {
                if (n4 > n5 - 1 || a2 > A.nCols()) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n4 = ++a2;
                n5 = a3;
            }
            n3 = ++a3;
        }
        return true;
    }

    public static boolean lowerTriangular(Matrix A, double epsilon) {
        int a2;
        if (A instanceof LowerTriangularMatrix) {
            return true;
        }
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int n2 = a2 + 1;
            while (n2 <= A.nCols()) {
                int a3;
                if (!DoubleUtils.equal(0.0, A.get(a2, a3), epsilon)) {
                    return false;
                }
                n2 = ++a3;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean orthogonal(Matrix A, double epsilon) {
        return AreMatrices.equal(A.multiply(A.t()), A.ONE(), epsilon);
    }

    public static boolean upperTriangular(Matrix A, double epsilon) {
        int a2;
        if (A instanceof UpperTriangularMatrix) {
            return true;
        }
        int n = a2 = 2;
        while (n <= A.nRows()) {
            int a3;
            int a4 = Math.min(a2, A.nCols());
            int n2 = a3 = 1;
            while (n2 < a4) {
                if (!DoubleUtils.equal(0.0, A.get(a2, a3), epsilon)) {
                    return false;
                }
                n2 = ++a3;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean skewSymmetric(Matrix A) {
        return A.t().equals(A.opposite());
    }

    @Deprecated
    public static boolean magicSquare(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static boolean tridiagonal(Matrix A, double epsilon) {
        int a2;
        int a3;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        int n = a3 = 1;
        while (n <= A.nRows()) {
            int n2 = a2 = 1;
            while (true) {
                if (n2 > a3 - 2) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n2 = ++a2;
            }
            n = ++a3;
        }
        int n3 = a3 = 1;
        while (n3 <= A.nRows()) {
            int n4 = A.nCols();
            while (true) {
                if (n4 < a3 + 2) break;
                if (!DoubleUtils.equal(0.0, A.get(a3, a2), epsilon)) {
                    return false;
                }
                n4 = --a2;
            }
            n3 = ++a3;
        }
        return true;
    }

    public static boolean diagonal(Matrix A, double epsilon) {
        boolean a2 = A.nRows() == A.nCols();
        if (a2) {
            int a3;
            int n = a3 = 1;
            while (n <= A.nRows()) {
                int a4;
                int n2 = a4 = 1;
                while (n2 <= A.nCols()) {
                    a2 = a3 == a4 ? (a2 &= DoubleUtils.compare(A.get(a3, a4), 0.0, epsilon) != 0) : (a2 &= DoubleUtils.compare(A.get(a3, a4), 0.0, epsilon) == 0);
                    n2 = ++a4;
                }
                n = ++a3;
            }
        }
        return a2;
    }

    public static boolean singular(Matrix A, double epsilon) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        boolean a2 = true;
        if (A instanceof TriangularMatrix) {
            int a3;
            int n = a3 = 1;
            while (n <= A.nRows()) {
                a2 &= !DoubleUtils.equal(A.get(a3, a3), 0.0, epsilon);
                n = ++a3;
            }
            a2 = !a2;
        } else {
            a2 = DoubleUtils.compare(Measure.det(A), 0.0) == 0;
        }
        return a2;
    }

    public static boolean zero(Vector v, double epsilon) {
        int a2;
        int n = a2 = 1;
        while (n <= v.size()) {
            if (!DoubleUtils.equal(v.get(a2), 0.0, epsilon)) {
                return false;
            }
            n = ++a2;
        }
        return true;
    }

    @Deprecated
    public static boolean scalar(Matrix A) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static boolean reducedRowEchelonForm(Matrix A, double epsilon) {
        int a2;
        int a3 = Integer.MIN_VALUE;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                if (!DoubleUtils.equal(0.0, A.get(a2, a4), epsilon)) {
                    if (!DoubleUtils.equal(1.0, A.get(a2, a4), epsilon) || a4 <= a3) {
                        return false;
                    }
                    int n3 = a2 - 1;
                    while (true) {
                        int a5;
                        if (n3 < 1) break;
                        if (!DoubleUtils.equal(0.0, A.get(a5, a4), epsilon)) {
                            return false;
                        }
                        n3 = --a5;
                    }
                    a3 = a4;
                    break;
                }
                n2 = ++a4;
            }
            if (a4 > A.nCols()) {
                a3 = a4;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean idempotent(Matrix A) {
        return A.equals(A.multiply(A));
    }

    public static boolean rowEchelonForm(Matrix A, double epsilon) {
        int a2;
        int a3 = Integer.MIN_VALUE;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                if (!DoubleUtils.equal(0.0, A.get(a2, a4), epsilon)) {
                    if (a4 <= a3) {
                        return false;
                    }
                    a3 = a4;
                    break;
                }
                n2 = ++a4;
            }
            if (a4 > A.nCols()) {
                a3 = a4;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean quasiTriangular(Matrix A, double epsilon) {
        if (A instanceof TriangularMatrix) {
            return true;
        }
        Hessenberg a2 = new Hessenberg(new Check4QuasiTriangular());
        if (!Hessenberg.isHessenberg(A, epsilon)) {
            return false;
        }
        DenseMatrix a3 = new DenseMatrix(A);
        return a2.backSearch((Matrix)a3, (int)a3.nRows(), (double)epsilon).isQuasiTriangular;
    }

    public static boolean symmetric(Matrix A) {
        if (A instanceof SymmetricMatrix) {
            return true;
        }
        return A.t().equals(A);
    }

    public static boolean identity(Matrix A, double epsilon) {
        boolean a2 = A.nRows() == A.nCols();
        if (a2) {
            int a3;
            int n = a3 = 1;
            while (n <= A.nRows()) {
                int a4;
                int n2 = a4 = 1;
                while (n2 <= A.nCols()) {
                    a2 = a3 == a4 ? (a2 &= DoubleUtils.compare(A.get(a3, a4), 1.0, epsilon) == 0) : (a2 &= DoubleUtils.compare(A.get(a3, a4), 0.0, epsilon) == 0);
                    n2 = ++a4;
                }
                n = ++a3;
            }
        }
        return a2;
    }

    private IsMatrix() {
        IsMatrix a2;
    }

    @Deprecated
    public static boolean positiveSemiDefinite(Matrix A) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static boolean positiveDefinite(Matrix A) {
        Matrix a2 = A.t();
        return IsMatrix.symmetricPositiveDefinite(A.add(a2).scaled(0.5));
    }

    private static class Check4QuasiTriangular
    implements Hessenberg.DeflationCriterion {
        public boolean isNegligible(Matrix A, int row, int col, double epsilon) {
            return DoubleUtils.equal(0.0, A.get(row, col), epsilon);
        }

        private Check4QuasiTriangular() {
            Check4QuasiTriangular a2;
        }
    }
}

