/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.diagonalization;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class Bidiagonalization {
    private final int B;
    private BidiagonalMatrix G;
    private Householder[] M;
    private Householder[] m;
    private final int H;

    public Matrix V() {
        int a2;
        int n = a2 = 1;
        while (n < this.M.length) {
            Vector a3 = this.M[a2].generator();
            Vector[] vectorArray = new Vector[2];
            vectorArray[0] = new DenseVector(a2);
            vectorArray[1] = a3;
            a3 = CreateVector.concat(vectorArray);
            this.M[a2] = new Householder(a3);
            n = ++a2;
        }
        Object a22 = null;
        a22 = this.M.length > 1 ? Householder.product(this.M, this.M.length - 1, 1) : new DenseMatrix(this.H, this.H).ONE();
        return a22.t();
    }

    public Matrix U() {
        int a2;
        int n = a2 = 1;
        while (n < this.m.length) {
            Vector a3 = this.m[a2].generator();
            Vector[] vectorArray = new Vector[2];
            vectorArray[0] = new DenseVector(a2 - 1);
            vectorArray[1] = a3;
            a3 = CreateVector.concat(vectorArray);
            this.m[a2] = new Householder(a3);
            n = ++a2;
        }
        Matrix a22 = Householder.product(this.m, this.m.length - 1, 1);
        return a22.t();
    }

    public Bidiagonalization(Matrix A) {
        Object a2;
        int a3;
        SuanShuUtils.assertArgument(DimensionCheck.isTall(A), b.C("xR]S_\\RTSWX@WO\\UD\u001bHJ^WD_Q\u001bNTJB\u0005Nu\u001bm[rW=WsOcSu^&"));
        this.B = A.nRows();
        this.H = A.nCols();
        Matrix a4 = A.deepCopy();
        this.m = new Householder[this.H + 1];
        this.M = new Householder[this.H - 1];
        int n = a3 = 1;
        while (n <= this.H) {
            a2 = Householder.getContext(CreateVector.subVector(a4.getColumn(a3), a3, this.B));
            this.m[a3] = new Householder(((Householder.Context)a2).generator);
            DenseMatrix a5 = CreateMatrix.subMatrix(a4, a3, this.B, a3, this.H);
            Matrix a6 = this.m[a3].reflect(a5);
            CreateMatrix.replace(a4, a3, this.B, a3, this.H, a6);
            if (a3 <= this.H - 2) {
                a2 = Householder.getContext(CreateVector.subVector(a4.getRow(a3), a3 + 1, this.H));
                this.M[a3] = new Householder(((Householder.Context)a2).generator);
                DenseMatrix a7 = CreateMatrix.subMatrix(a4, a3, this.B, a3 + 1, this.H);
                Matrix a8 = this.M[a3].reflectRows(a7);
                CreateMatrix.replace(a4, a3, this.B, a3 + 1, this.H, a8);
            }
            n = ++a3;
        }
        double[] a22 = a4.nCols() > 1 ? CreateVector.superDiagonal(a4).toArray() : null;
        a2 = CreateVector.diagonal(a4).toArray();
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = a22;
        dArrayArray[1] = (double[])a2;
        this.G = new BidiagonalMatrix(dArrayArray);
    }

    public BidiagonalMatrix B() {
        return new BidiagonalMatrix(this.G);
    }
}

