/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.EigenDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.QRAlgorithm;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.Solver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.NumberUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Eigen
implements Spectrum,
EigenDecomposition {
    private final Matrix M;
    private volatile boolean m = false;
    public final double epsilon;
    private final TreeMap<Number, Property> H;

    public Matrix Qt() {
        return this.Q().t();
    }

    public Number eigenvalue(int i2) {
        int a2;
        Iterator<Number> a3 = this.H.keySet().iterator();
        int n = a2 = 0;
        while (n < i2) {
            a3.next();
            n = ++a2;
        }
        return a3.next();
    }

    public Eigen(Matrix A) {
        this(A, Method.QR, 10.0 * SuanShuUtils.autoEpsilon(A));
    }

    public DiagonalMatrix D() {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(this.M), b.C("CNBCL\u0007ECMH@VET@R_H[\u0006SWAJWBN\u0006UIU_&Sj\u0006qVtG|B-KkS{OuB&"));
        double[] a2 = new double[this.M.nRows()];
        int a3 = 0;
        Iterator<Map.Entry<Number, Property>> a4 = this.H.entrySet().iterator();
        while (a4.hasNext()) {
            int a5;
            Number a6 = a4.next().getKey();
            Property a7 = this.property(a6);
            int n = a5 = 0;
            while (n < a7.M) {
                a2[a3++] = a6.doubleValue();
                n = ++a5;
            }
        }
        return new DiagonalMatrix(a2);
    }

    private void H() {
        Eigen a2;
        Iterator<Map.Entry<Number, Property>> a3 = a2.H.entrySet().iterator();
        while (a3.hasNext()) {
            int a4;
            Property a5 = a3.next().getValue();
            Number a6 = a5.m;
            if (!NumberUtils.isReal(a6)) continue;
            DenseMatrix a7 = new DenseMatrix(a2.M);
            int n = a4 = 1;
            while (n <= a7.nRows()) {
                a7.set(a4, a4, a7.get(a4, a4) - a6.doubleValue());
                n = ++a4;
            }
            Solver a22 = new Solver(a7, a2.epsilon);
            VectorList a8 = a22.homogeneousSoln();
            a5.H.addAll(a8);
            if (a5.M <= 1) continue;
            Vector a9 = (Vector)a5.H.get(0);
            Property property = a5;
            while (property.H.size() < a5.M) {
                Vector a10 = a22.solve(a9);
                a5.H.add(a10);
                a9 = a10;
                property = a5;
            }
        }
        a2.m = true;
    }

    public int size() {
        return this.H.keySet().size();
    }

    public Matrix Q() {
        Iterator<Map.Entry<Number, Property>> a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(this.M), b.C("CNBCL\u0007ECMH@VET@R_H[\u0006SWAJWBN\u0006UIU_&Sj\u0006qVtG|B-KkS{OuB&"));
        VectorList a3 = new VectorList();
        Iterator<Map.Entry<Number, Property>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Number a4 = a2.next().getKey();
            Property a5 = this.property(a4);
            a3.addAll(a5.H);
            iterator = a2;
        }
        return CreateMatrix.cbind(a3);
    }

    public Property getProperty(int i2) {
        return this.property(this.eigenvalue(i2));
    }

    public Eigen(Matrix A, Method method, final double epsilon) {
        Spectrum a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("Q|pq~crxip?p}vtytzt}t|lz,t\u007fdd|ng\u0014zYxI5G{\u001cfNaYg^4ItSfI-"));
        this.epsilon = epsilon;
        this.M = A;
        this.H = new TreeMap(new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                return -NumberUtils.compare(o1, o2, epsilon);
            }
            {
                1 a2;
            }
        });
        switch (method) {
            case CHARACTERISTIC_POLYNOMIAL: {
                a2 = new CharacteristicPolynomial(this.M);
                break;
            }
            case SYMMETRY: {
                do {
                } while (false);
                throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
            }
            default: {
                a2 = new QRAlgorithm(this.M, Integer.MAX_VALUE, epsilon);
            }
        }
        for (Number a3 : a2.eigenvalues()) {
            Property a4;
            if (this.H.containsKey(a3)) {
                a4 = this.H.get(a3);
                ++a4.M;
                continue;
            }
            a4 = new Property(a3);
            this.H.put(a3, a4);
        }
    }

    public NumberList eigenvalues() {
        NumberList a2 = new NumberList();
        a2.addAll(this.H.keySet());
        return a2;
    }

    public double[] realEigenvalues() {
        NumberList a2 = new NumberList();
        for (Number a3 : this.H.keySet()) {
            if (!NumberUtils.isReal(a3)) continue;
            a2.add(a3);
        }
        return a2.doubleArray();
    }

    public Property property(Number eigenvalue) {
        if (!this.m) {
            this.H();
        }
        return new Property(this.H.get(eigenvalue));
    }

    public static class Property {
        private int M;
        private Number m;
        private VectorList H;

        public Number eigenvalue() {
            return this.m;
        }

        public Vector eigenVector() {
            return (Vector)this.H.get(0);
        }

        public int algebraicMultiplicity() {
            return this.M;
        }

        public int geometricMultiplicity() {
            return this.H.size();
        }

        private Property(Number a2) {
            Property a3;
            a3.m = a2;
            a3.M = 1;
            a3.H = new VectorList();
        }

        private Property(Property a2) {
            Property a3;
            a3.m = a2.m;
            a3.M = a2.M;
            a3.H = new VectorList(a2.H);
        }

        public VectorList eigenbasis() {
            return this.H.deepCopy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method CHARACTERISTIC_POLYNOMIAL = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method QR;
        public static final /* enum */ Method SYMMETRY;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            SYMMETRY = new Method();
            QR = new Method();
            Method[] methodArray = new Method[3];
            methodArray[0] = CHARACTERISTIC_POLYNOMIAL;
            methodArray[1] = SYMMETRY;
            methodArray[2] = QR;
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

