/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Hessenberg;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class HessenbergDecomposition {
    private Matrix G;
    private final int M;
    private volatile Matrix m = null;
    private Householder[] H;

    public HessenbergDecomposition(Matrix A) {
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("]qeftzppos>G|povq}i{!urea}kf){dyL4Bz\u0011gC`\\f[5TuNgLwC&"));
        this.M = A.nRows();
        if (Hessenberg.isHessenberg(A, 0.0)) {
            this.G = A.deepCopy();
            this.m = A.ONE();
            return;
        }
        this.G = A.deepCopy();
        this.H = new Householder[this.M - 1];
        int n = a2 = 1;
        while (true) {
            if (n > this.M - 2) break;
            Householder.Context a3 = Householder.getContext(CreateVector.subVector(this.G.getColumn(a2), a2 + 1, this.M));
            this.H[a2] = new Householder(a3.generator);
            DenseMatrix a4 = CreateMatrix.subMatrix(this.G, a2 + 1, this.M, a2, this.M);
            Matrix a5 = this.H[a2].reflect(a4);
            CreateMatrix.replace(this.G, a2 + 1, this.M, a2, this.M, a5);
            DenseMatrix a6 = CreateMatrix.subMatrix(this.G, 1, this.M, a2 + 1, this.M);
            Matrix a7 = this.H[a2].reflectRows(a6);
            CreateMatrix.replace(this.G, 1, this.M, a2 + 1, this.M, a7);
            n = ++a2;
        }
    }

    public Matrix H() {
        return this.G.deepCopy();
    }

    public Matrix Q() {
        if (this.m == null) {
            int a2;
            int n = a2 = 1;
            while (true) {
                if (n > this.M - 2) break;
                Vector a3 = this.H[a2].generator();
                Vector[] vectorArray = new Vector[2];
                vectorArray[0] = new DenseVector(a2);
                vectorArray[1] = a3;
                a3 = CreateVector.concat(vectorArray);
                this.H[a2] = new Householder(a3);
                n = ++a2;
            }
            this.m = Householder.product(this.H, 1, this.M - 2, this.M, this.M);
        }
        return this.m.deepCopy();
    }
}

