/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.datastructure.list.MatrixList;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.FrancisQRStep;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Hessenberg;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.HessenbergDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.util.Iterator;

public class QRAlgorithm
implements Spectrum {
    private final int B;
    public final double epsilon;
    private final Matrix G;
    private final Matrix M;
    private MatrixList m = new MatrixList();
    private final int H;

    public QRAlgorithm(Matrix A, int maxIterations, double epsilon) {
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException(b.C("Q|pq~crxip?p}vtytzt}t|lz,t\u007fdd|ng\u0014zYxI5G{\u001cfNaYg^4ItSfI-"));
        }
        this.H = A.nRows();
        this.M = A;
        this.B = maxIterations;
        this.epsilon = epsilon;
        HessenbergDecomposition a2 = new HessenbergDecomposition(A);
        this.G = a2.H();
        this.m.add(a2.Q());
    }

    /*
     * Unable to fully structure code
     */
    public NumberList eigenvalues() {
        a = new Hessenberg();
        a = a.backSearch(this.G, this.H, this.epsilon);
        v0 = a = 0;
        v1 = this;
        while (v0 < v1.B && !a.isQuasiTriangular) {
            a = CreateMatrix.subMatrix(this.G, a.ul, a.lr, a.ul, a.lr);
            a = new FrancisQRStep(a);
            a = a.ZtHZ();
            CreateMatrix.replace(this.G, a.ul, a.lr, a.ul, a.lr, (Matrix)a);
            a = this.G.ONE();
            CreateMatrix.replace((Matrix)a, a.ul, a.lr, a.ul, a.lr, a.Z());
            this.m.add(a);
            a = a.backSearch(this.G, this.H, this.epsilon);
            v0 = ++a;
            v1 = this;
        }
        a = new NumberList();
        v2 = a = 1;
        while (v2 <= this.H) {
            if (a == this.H) ** GOTO lbl-1000
            if (a.deflationCriterion.isNegligible(this.G, a + 1, a, this.epsilon)) lbl-1000:
            // 2 sources

            {
                a = CreateMatrix.subMatrix(this.G, a, a, a, a);
            } else {
                a = CreateMatrix.subMatrix(this.G, a, a + 1, a, a + 1);
                a += 2;
            }
            a = new CharacteristicPolynomial((Matrix)a);
            a = a.eigenvalues();
            a.addAll(a);
            v2 = ++a;
        }
        return a;
    }

    public Matrix T() {
        Matrix a2 = this.Q();
        return a2.t().multiply(this.M).multiply(a2);
    }

    public Matrix Q() {
        Iterator a2;
        Matrix a3 = this.G.ONE();
        Iterator iterator = a2 = this.m.iterator();
        while (iterator.hasNext()) {
            Matrix a4 = (Matrix)a2.next();
            a3 = a3.multiply(a4);
            iterator = a2;
        }
        return a3;
    }

    public QRAlgorithm(Matrix A) {
        this(A, Integer.MAX_VALUE, SuanShuUtils.autoEpsilon(A));
    }
}

