/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.ElementaryOperation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class GaussJordanElimination {
    public final int nrows;
    public final boolean usePivoting;
    public final int ncols;
    private ElementaryOperation m;
    private ElementaryOperation H;
    public final double epsilon;

    public Matrix T() {
        return this.H.T();
    }

    public GaussJordanElimination(Matrix A, boolean usePivoting, double epsilon) {
        this.nrows = A.nRows();
        this.ncols = A.nCols();
        this.usePivoting = usePivoting;
        this.epsilon = epsilon;
        this.H = new ElementaryOperation(this.nrows, this.nrows);
        this.m = new ElementaryOperation(A);
        this.H();
    }

    public Matrix U() {
        return this.m.T();
    }

    private void H() {
        int a2;
        GaussJordanElimination a3;
        int[] a4 = new int[a3.nrows + 1];
        int a5 = 1;
        int n = a5;
        GaussJordanElimination gaussJordanElimination = a3;
        for (a2 = 1; n <= gaussJordanElimination.nrows && a2 <= a3.ncols; ++a2) {
            int a6 = a5;
            if (a3.usePivoting) {
                int n2 = a5 + 1;
                while (n2 <= a3.nrows) {
                    int a7;
                    if (Math.abs(a3.m.get(a7, a2)) > Math.abs(a3.m.get(a6, a2))) {
                        a6 = a7;
                    }
                    n2 = ++a7;
                }
            }
            if (DoubleUtils.compare(a3.m.get(a6, a2), 0.0, a3.epsilon) != 0) {
                int a8;
                if (a5 != a6) {
                    a3.m.swapRow(a5, a6);
                    a3.H.swapRow(a5, a6);
                }
                double a9 = a3.m.get(a5, a2);
                a3.m.scaleRow(a5, 1.0 / a9);
                a4[a5] = a2;
                a3.H.scaleRow(a5, 1.0 / a9);
                int n3 = a8 = 1;
                while (n3 <= a3.nrows) {
                    if (a8 != a5) {
                        a9 = a3.m.get(a8, a2) / a3.m.get(a5, a2);
                        a3.m.addRow(a8, a5, -a9);
                        a3.H.addRow(a8, a5, -a9);
                    }
                    n3 = ++a8;
                }
            }
            n = ++a5;
            gaussJordanElimination = a3;
        }
        Matrix a22 = a3.m.T();
        int n4 = a2 = 1;
        while (n4 <= a3.nrows) {
            if (a4[a2] > 0) {
                a22.set(a2, a4[a2], 1.0);
            }
            n4 = ++a2;
        }
        a3.m = new ElementaryOperation(a22);
    }

    public GaussJordanElimination(Matrix A) {
        this(A, true, SuanShuUtils.autoEpsilon(A));
    }
}

