/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.ElementaryOperation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class GaussianElimination {
    private Matrix C;
    public final double epsilon;
    private final int F;
    private final int B;
    private PermutationMatrix G;
    private final boolean M;
    private ElementaryOperation m;
    private ElementaryOperation H;

    public PermutationMatrix P() {
        return new PermutationMatrix(this.G);
    }

    public GaussianElimination(Matrix A) {
        this(A, true, SuanShuUtils.autoEpsilon(A));
    }

    public Matrix T() {
        return this.H.T();
    }

    public Matrix U() {
        return this.m.T();
    }

    public GaussianElimination(Matrix A, boolean usePivoting, double epsilon) {
        this.B = A.nRows();
        this.F = A.nCols();
        this.M = usePivoting;
        this.epsilon = epsilon;
        this.H = new ElementaryOperation(this.B, this.B);
        this.m = new ElementaryOperation(A);
        this.C = new DenseMatrix(this.B, this.B).ONE();
        this.G = new PermutationMatrix(this.B);
        this.H();
    }

    public Matrix L() {
        return this.C.deepCopy();
    }

    private void H(int a2, int a3) {
        int a4;
        GaussianElimination a5;
        Vector a6 = a5.C.getRow(a2);
        int n = a4 = 1;
        while (n < a2) {
            a5.C.set(a2, a4, a5.C.get(a3, a4));
            a5.C.set(a3, a4, a6.get(a4));
            n = ++a4;
        }
    }

    private void H() {
        GaussianElimination a2;
        int a3 = 1;
        int n = a3;
        GaussianElimination gaussianElimination = a2;
        for (int a4 = 1; n <= gaussianElimination.B && a4 <= a2.F; ++a4) {
            int a5;
            int a6 = a3;
            if (a2.M) {
                int n2 = a3 + 1;
                while (n2 <= a2.B) {
                    if (Math.abs(a2.m.T().get(a5, a4)) > Math.abs(a2.m.T().get(a6, a4))) {
                        a6 = a5;
                    }
                    n2 = ++a5;
                }
            }
            if (DoubleUtils.compare(a2.m.T().get(a6, a4), 0.0, a2.epsilon) != 0) {
                if (a3 != a6) {
                    a2.m.swapRow(a3, a6);
                    a2.H.swapRow(a3, a6);
                    a2.G.swapRow(a3, a6);
                    a2.H(a3, a6);
                }
                int n3 = a3 + 1;
                while (n3 <= a2.B) {
                    double a7 = a2.m.T().get(a5, a4) / a2.m.T().get(a3, a4);
                    a2.m.addRow(a5, a3, -a7);
                    a2.H.addRow(a5, a3, -a7);
                    a2.C.set(a5, a4, a7);
                    n3 = ++a5;
                }
            }
            n = ++a3;
            gaussianElimination = a2;
        }
    }
}

