/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class HouseholderReflection
implements QRDecomposition {
    private UpperTriangularMatrix M;
    public final double epsilon;
    public final int nrows;
    public final int ncols;
    private Householder[] m;
    private Vector[] H;

    public PermutationMatrix P() {
        return new PermutationMatrix(this.ncols);
    }

    private void H() {
        HouseholderReflection a2;
        int a3;
        int n = a3 = 2;
        while (n <= a2.ncols) {
            int a4;
            int n2 = a4 = 1;
            while (n2 < a3) {
                a2.M.set(a4, a3, a2.H[a3].get(a4));
                n2 = ++a4;
            }
            n = ++a3;
        }
        if (a2.nrows == a2.ncols) {
            a2.M.set(a2.ncols, a2.ncols, a2.H[a2.ncols].get(a2.ncols));
        }
    }

    public HouseholderReflection(Matrix A, double epsilon) {
        int a2;
        SuanShuUtils.assertArgument(A.nRows() >= A.nCols(), b.C("`b\u0012UPSY\\I_IXIYQ_\u0001R[\u0011m_SBLXE]IU\\\u0011CUt]pSbXv^:Pm@rXdC\"Ej\u0010kP}BcI-GfTCU\u0012_@]TTK\u0010UW\u001dBQFR\u0010\u001c\u0011KEKSLB\n^K\u0010M^}E\u007f_&"));
        this.nrows = A.nRows();
        this.ncols = A.nCols();
        this.epsilon = epsilon;
        this.M = new UpperTriangularMatrix(this.ncols);
        this.M.set(1, 1, 0.0);
        this.H = new Vector[this.ncols + 1];
        this.m = new Householder[this.ncols + 1];
        int n = a2 = 1;
        while (n <= this.ncols) {
            this.H[a2] = A.getColumn(a2);
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (true) {
            if (n2 > Math.min(this.ncols, this.nrows - 1)) break;
            Householder.Context a3 = Householder.getContext(CreateVector.subVector(this.H[a2], a2, this.nrows));
            Vector a4 = a3.generator;
            if (DoubleUtils.compare(Math.abs(a3.lambda), epsilon) <= 0) {
                a4 = new DenseVector(this.nrows);
                this.m[a2] = new Householder(a4);
                this.M.set(a2, a2, 0.0);
            } else {
                Vector[] vectorArray = new Vector[2];
                vectorArray[0] = new DenseVector(a2 - 1);
                vectorArray[1] = a4;
                a4 = CreateVector.concat(vectorArray);
                this.m[a2] = new Householder(a4);
                int n3 = a2 + 1;
                while (n3 <= this.ncols) {
                    int a5;
                    this.H[a5] = this.m[a2].reflect(this.H[a5]);
                    n3 = ++a5;
                }
                this.M.set(a2, a2, a3.lambda);
            }
            n2 = ++a2;
        }
        this.H();
    }

    public Matrix squareQ() {
        return Householder.product(this.m, 1, this.ncols, this.nrows, this.nrows);
    }

    public Matrix tallR() {
        Object a2 = new DenseMatrix(this.nrows, this.ncols).ZERO();
        CreateMatrix.replace((Matrix)a2, 1, this.ncols, 1, this.ncols, this.M);
        return a2;
    }

    public int rank() {
        int a2;
        int a3 = 0;
        int n = a2 = 1;
        while (n <= this.M.nCols()) {
            if (DoubleUtils.compare(this.M.get(a2, a2), 0.0, this.epsilon) != 0) {
                ++a3;
            }
            n = ++a2;
        }
        return a3;
    }

    public HouseholderReflection(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }

    public Matrix Q() {
        return Householder.product(this.m, 1, this.ncols, this.nrows, this.ncols);
    }

    public UpperTriangularMatrix R() {
        return new UpperTriangularMatrix(this.M);
    }
}

