/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.GramSchmidt;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class QR
implements QRDecomposition {
    public final double epsilon;
    private final QRDecomposition H;

    public Matrix Q() {
        return this.H.Q();
    }

    public QR(Matrix A, Method method, double epsilon) {
        SuanShuUtils.assertArgument(A.nRows() >= A.nCols(), b.C("ns|:OI=~wx~wftfs~rft.z}jnrdi&oj:WzMhWc\u001dmZ~C\u007f\u0016u@wH~[:A}\rhMlR:\u0018;Kowy|h>t{:qt}o{u&"));
        this.epsilon = epsilon;
        switch (method) {
            case GRAM_SCHMIDT: {
                do {
                } while (false);
                this.H = new GramSchmidt(A, true, epsilon);
                break;
            }
            default: {
                this.H = new HouseholderReflection(A, epsilon);
            }
        }
    }

    public QR(Matrix A) {
        this(A, Method.HOUSEHOLDER_REFLECTION, SuanShuUtils.autoEpsilon(A));
    }

    public UpperTriangularMatrix R() {
        return this.H.R();
    }

    public Matrix squareQ() {
        return this.H.squareQ();
    }

    public int rank() {
        return this.H.rank();
    }

    public PermutationMatrix P() {
        return this.H.P();
    }

    public Matrix tallR() {
        return this.H.tallR();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method HOUSEHOLDER_REFLECTION;
        public static final /* enum */ Method GRAM_SCHMIDT;
        private static final /* synthetic */ Method[] $VALUES;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            GRAM_SCHMIDT = new Method();
            HOUSEHOLDER_REFLECTION = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = GRAM_SCHMIDT;
            methodArray[1] = HOUSEHOLDER_REFLECTION;
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

