/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.MatrixRing;
import com.numericalmethod.suanshu.matrix.doubles.factorization.diagonalization.Bidiagonalization;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.GloubKahanSVDStep;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVDDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.Arrays;
import java.util.Comparator;

public class GloubKahanSVD
implements SVDDecomposition {
    private final Matrix f;
    private Matrix J;
    private final int C;
    private final boolean F;
    private final int B;
    public final double epsilon;
    private Matrix G;
    private final int M = 100;
    private DiagonalMatrix m;
    private final boolean H;

    private void C() {
        int a2;
        int a3;
        GloubKahanSVD a4;
        int a5 = a4.m.nRows();
        class UDVt {
            Double sv;
            Vector u;
            Vector vt;

            UDVt(Double a2, Vector a3, Vector a4) {
                UDVt a5;
                a5.sv = a2;
                a5.u = a3;
                a5.vt = a4;
            }
        }
        UDVt[] a6 = new UDVt[a5];
        int n = a3 = 1;
        while (n <= a5) {
            double a7 = a4.m.get(a3, a3);
            a6[a3 - 1] = a4.new UDVt(a7 < 0.0 ? -a7 : a7, a7 < 0.0 ? a4.J.getRow(a3).scaled(-1.0) : a4.J.getRow(a3), a4.G.getColumn(a3));
            n = ++a3;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UtDVComparator
        implements Comparator<UDVt> {
            @Override
            public int compare(UDVt sv1, UDVt sv2) {
                return -1 * Double.compare(sv1.sv, sv2.sv);
            }

            UtDVComparator() {
                UtDVComparator a2;
            }
        }
        Arrays.sort(a6, a4.new UtDVComparator());
        Vector[] a22 = new Vector[a4.J.nRows()];
        Vector[] a8 = new Vector[a4.G.nCols()];
        int n2 = a2 = 0;
        while (n2 < a5) {
            a22[a2] = a6[a2].u;
            a4.m.set(a2 + 1, a2 + 1, a6[a2].sv);
            a8[a2] = a6[a2].vt;
            n2 = ++a2;
        }
        int n3 = a2 = a5;
        while (n3 < a4.J.nRows()) {
            a22[a2] = new DenseVector(a4.J.nCols());
            n3 = ++a2;
        }
        a4.J = CreateMatrix.rbind(a22);
        a4.G = CreateMatrix.cbind(a8);
    }

    private Matrix C(SubMatrixRef a2) {
        int a3;
        int a4 = a2.nRows();
        Matrix a5 = a2;
        Object a6 = new DenseMatrix(a4, a4).ONE();
        int n = a3 = a4 - 1;
        while (true) {
            if (n < 1) break;
            GivensMatrix a7 = GivensMatrix.CtorToRotateColumns(a4, a3, a4, a5.get(a3, a3), a5.get(a3, a4));
            a5 = a5.multiply(a7);
            a6 = a6.multiply(a7);
            n = --a3;
        }
        return a6;
    }

    private void H() {
        int a2;
        GloubKahanSVD a3;
        Bidiagonalization a4 = new Bidiagonalization(a3.f);
        Matrix a5 = a4.U();
        Matrix a6 = a4.V();
        Matrix a7 = a4.B();
        int a8 = a7.nRows();
        Object a9 = null;
        Object a10 = null;
        int a11 = 0;
        int a12 = 0;
        int n = a2 = 0;
        while (true) {
            Matrix a13;
            if (n >= 100) break;
            int n2 = a8;
            while (true) {
                if (n2 <= 1) break;
                if (DoubleUtils.compare(a7.get(a11 - 1, a11), 0.0, a3.epsilon) != 0) break;
                n2 = --a11;
            }
            if (a11 <= 1) break;
            int n3 = a11 - 1;
            while (true) {
                if (n3 < 2) break;
                if (DoubleUtils.compare(a7.get(a12 - 1, a12), 0.0, a3.epsilon) == 0) break;
                n3 = --a12;
            }
            SubMatrixRef a14 = new SubMatrixRef(a7, a12, a11, a12, a11);
            Object a15 = new DenseMatrix(a8, a8).ONE();
            Object a16 = new DenseMatrix(a8, a8).ONE();
            if (DoubleUtils.compare(a14.get(a14.nRows(), a14.nCols()), 0.0, a3.epsilon) == 0) {
                a13 = a3.C(a14);
                CreateMatrix.replace((Matrix)a16, a12, a11, a12, a11, a13);
            } else if (DoubleUtils.anyZero(CreateVector.diagonal(a14).toArray(), a3.epsilon)) {
                a13 = a3.H(a14);
                CreateMatrix.replace((Matrix)a15, a12, a11, a12, a11, a13);
            } else {
                double[][] dArrayArray = new double[2][];
                dArrayArray[0] = CreateVector.superDiagonal(a14).toArray();
                dArrayArray[1] = CreateVector.diagonal(a14).toArray();
                a13 = new BidiagonalMatrix(dArrayArray);
                GloubKahanSVDStep a17 = new GloubKahanSVDStep((BidiagonalMatrix)a13);
                CreateMatrix.replace((Matrix)a15, a12, a11, a12, a11, a17.U().t());
                CreateMatrix.replace((Matrix)a16, a12, a11, a12, a11, a17.V());
            }
            a7 = a15.multiply(a7).multiply((Matrix)a16);
            if (a3.H) {
                a9 = a9 == null ? a15 : a15.multiply((Matrix)a9);
                a10 = a10 == null ? a16 : a10.multiply((Matrix)a16);
            }
            n = ++a2;
        }
        a3.m = new DiagonalMatrix(CreateVector.diagonal(a7).toArray());
        if (a3.H) {
            if (a9 == null) {
                a3.J = CreateMatrix.subMatrix(a5.t(), 1, a8, 1, a5.nRows());
            } else {
                MatrixRing a18 = a9;
                if (a3.B > a8) {
                    Matrix[] matrixArray = new Matrix[2];
                    matrixArray[0] = a9;
                    matrixArray[1] = new DenseMatrix(a8, a3.B - a8).ZERO();
                    a18 = CreateMatrix.cbind(matrixArray);
                }
                a3.J = a18.multiply(a5.t());
            }
            Matrix matrix = a3.G = a10 == null ? a6 : a6.multiply((Matrix)a10);
        }
        if (a3.F && a3.H) {
            a3.C();
        }
    }

    public Matrix Ut() {
        SuanShuUtils.assertOrThrow(this.H ? null : new RuntimeException(b.C("III_\u0002THHIRAGX\u0007_GZRPU\u0012PTT[\u0007^IWWLRcC>\u0006W\u0007oIz\u0007lPkNeGtK0")));
        return this.J.deepCopy();
    }

    public GloubKahanSVD(Matrix A, boolean doUV, boolean normalize, double epsilon) {
        SuanShuUtils.assertArgument(DimensionCheck.isTall(A), b.C("U5zaca3vy5kut9"));
        this.f = A;
        this.B = A.nRows();
        this.C = A.nCols();
        this.H = doUV;
        this.F = normalize;
        this.epsilon = epsilon;
        this.H();
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.m);
    }

    public Matrix U() {
        SuanShuUtils.assertOrThrow(this.H ? null : new RuntimeException(b.C("III_\u0002THHIRAGX\u0007_GZRPU\u0012PTT[\u0007^IWWLRcC>\u0006W\u0007oIz\u0007lPkNeGtK0")));
        return this.J.t();
    }

    public Matrix V() {
        SuanShuUtils.assertOrThrow(this.H ? null : new RuntimeException(b.C("III_\u0002THHIRAGX\u0007_GZRPU\u0012PTT[\u0007^IWWLRcC>\u0006T\u0007oIz\u0007lPkNeGtK0")));
        return this.G.deepCopy();
    }

    public double[] singularValues() {
        int a2;
        double[] a3 = this.m.diagonal().toArray();
        int n = a2 = 0;
        while (n < a3.length) {
            if (a3[a2] < 0.0) {
                int n2 = a2;
                a3[n2] = a3[n2] * -1.0;
            }
            n = ++a2;
        }
        return a3;
    }

    private Matrix H(SubMatrixRef a2) {
        int a3;
        int a4;
        int a5 = a2.nCols();
        int n = a4 = 1;
        while (n <= a5) {
            GloubKahanSVD a6;
            if (DoubleUtils.compare(a2.get(a4, a4), 0.0, a6.epsilon) == 0) {
                if (DoubleUtils.compare(a2.get(a4, a4 + 1), 0.0, a6.epsilon) != 0) break;
            }
            n = ++a4;
        }
        if (a4 >= a5) {
            throw new RuntimeException(b.C("zz7nug|4x|~sw{zx$pi`r,"));
        }
        Matrix a7 = a2;
        Object a8 = new DenseMatrix(a5, a5).ONE();
        int n2 = a3 = a4 + 1;
        while (n2 <= a5) {
            GivensMatrix a9 = GivensMatrix.CtorToRotateRows(a5, a3, a4, a7.get(a3, a3), a7.get(a4, a3));
            a7 = a9.multiply(a7);
            a8 = a9.multiply((Matrix)a8);
            n2 = ++a3;
        }
        return a8;
    }
}

