/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.GloubKahanSVD;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVDDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class SVD
implements SVDDecomposition {
    private final Matrix B;
    private final Method G;
    private SVDDecomposition M;
    private final boolean m;
    public final double epsilon;
    private boolean H;

    public Matrix Ut() {
        return this.U().t();
    }

    public Matrix U() {
        Matrix a2 = this.H ? this.M.V() : this.M.U();
        return a2;
    }

    public double[] singularValues() {
        return this.M.singularValues();
    }

    public Matrix V() {
        Matrix a2 = this.H ? this.M.U() : this.M.V();
        return a2;
    }

    public SVD(Matrix A, boolean doUV) {
        this(A, doUV, Method.GLOUB_KAHAN, SuanShuUtils.autoEpsilon(A));
    }

    public SVD(Matrix A, boolean doUV, Method method, double epsilon) {
        this.B = A;
        this.m = doUV;
        this.G = method;
        this.epsilon = epsilon;
        this.H = DimensionCheck.isFat(A);
        switch (method) {
            default: 
        }
        this.M = new GloubKahanSVD(this.H ? this.B.t() : this.B, this.m, true, epsilon);
    }

    public DiagonalMatrix D() {
        return this.M.D();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GLOUB_KAHAN = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        static {
            Method[] methodArray = new Method[1];
            methodArray[0] = GLOUB_KAHAN;
            $VALUES = methodArray;
        }

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

