/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Cholesky {
    private LowerTriangularMatrix H;

    public Cholesky(Matrix A) {
        if (!IsMatrix.symmetric(A)) {
            throw new IllegalArgumentException(b.C("aKNNCPN[\nGLAAN]MAJEKYM\u0015CJSUK[P\u001dVm\u0003nLjZ%QsNdGzQdA2NpVdJ-"));
        }
        this.H(A);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.H);
    }

    private void H(Matrix a2) {
        int a3;
        int a4 = a2.nRows();
        a6.H = new LowerTriangularMatrix(a4);
        int n = a3 = 1;
        while (n <= a4) {
            int a5;
            Cholesky a6;
            int a7;
            int n2 = a7 = 1;
            while (n2 < a3) {
                int a8;
                double a9 = a2.get(a3, a7);
                int n3 = a8 = 1;
                while (true) {
                    if (n3 > a7 - 1) break;
                    a9 -= a6.H.get(a3, a8) * a6.H.get(a7, a8);
                    n3 = ++a8;
                }
                a6.H.set(a3, a7, a9 /= a6.H.get(a7, a7));
                n2 = ++a7;
            }
            double a22 = a2.get(a3, a3);
            int n4 = a5 = 1;
            while (true) {
                if (n4 > a3 - 1) break;
                a22 -= a6.H.get(a3, a5) * a6.H.get(a3, a5);
                n4 = ++a5;
            }
            if (DoubleUtils.compare(a22, 0.0) <= 0) {
                throw new RuntimeException(b.C("U5~g0{|`<epgqarba5cqf|m}x0"));
            }
            a22 = Math.sqrt(a22);
            a6.H.set(a3, a3, a22);
            n = ++a3;
        }
    }

    public UpperTriangularMatrix Lt() {
        return this.H.t();
    }
}

