/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LUDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Doolittle
implements LUDecomposition {
    private LowerTriangularMatrix G;
    private UpperTriangularMatrix M;
    public final double epsilon;
    public final boolean usePivoting;
    public final int dim;
    private PermutationMatrix m;
    private double[][] H;

    private void H() {
        Doolittle a2;
        int a3;
        int n = a3 = 1;
        while (n <= a2.dim) {
            double a4;
            Vector a5;
            int a6;
            if (a2.usePivoting) {
                a2.H(a3);
            }
            DenseVector a7 = a2.G.getRow(a3);
            int n2 = a6 = a3;
            while (n2 <= a2.dim) {
                int a8;
                a5 = a2.M.getColumn(a6);
                a4 = 0.0;
                int n3 = a8 = 1;
                while (n3 < a3) {
                    a4 += a7.get(a8) * a5.get(a8);
                    n3 = ++a8;
                }
                a4 = a2.H[a3 - 1][a6 - 1] - a4;
                a2.M.set(a3, a6, a4);
                n2 = ++a6;
            }
            a5 = a2.M.getColumn(a3);
            int n4 = a6 = a3 + 1;
            while (n4 <= a2.dim) {
                int a9;
                a7 = a2.G.getRow(a6);
                a4 = 0.0;
                int n5 = a9 = 1;
                while (n5 < a3) {
                    a4 += a7.get(a9) * a5.get(a9);
                    n5 = ++a9;
                }
                a4 = a2.H[a6 - 1][a3 - 1] - a4;
                double a22 = a2.M.get(a3, a3);
                if (DoubleUtils.compare(a4, 0.0, a2.epsilon) != 0 && DoubleUtils.compare(a22, 0.0, a2.epsilon) == 0) {
                    throw new MatrixSingularityException(b.C("}fci\u007fch|o{|.fjuk}{xj:kl|\u007far.fgt.bZ\rjOlFcV`VgVfN`\u0005/Th\u001a\u007fPxY{\\`U/X}.z~kn#)ztv%o\"mhiyjo.\u007f\u007fjgz`;"));
                }
                a4 = DoubleUtils.compare(a22, 0.0, a2.epsilon) == 0 ? 1.0 : (a4 /= a22);
                a2.G.set(a6, a3, a4);
                n4 = ++a6;
            }
            n = ++a3;
        }
    }

    public UpperTriangularMatrix U() {
        return new UpperTriangularMatrix(this.M);
    }

    public Doolittle(Matrix A) {
        this(A, true, SuanShuUtils.autoEpsilon(A));
    }

    private double H(int a2, int a3) {
        int a4;
        Doolittle a5;
        double a6 = a5.H[a2 - 1][a3 - 1];
        int n = a4 = 1;
        while (n < a2) {
            a6 -= a5.G.get(a2, a4) * a5.M.get(a4, a3);
            n = ++a4;
        }
        return Math.abs(a6);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.G);
    }

    public PermutationMatrix P() {
        return new PermutationMatrix(this.m);
    }

    public Doolittle(Matrix A, boolean usePivoting, double epsilon) {
        int a2;
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException(b.C("`}r4\\@3pyvpyhzh}p|hz tsd`|jg(ad4GdBuBp\u0013y]aM}@5TzH,"));
        }
        this.dim = A.nRows();
        this.usePivoting = usePivoting;
        this.epsilon = epsilon;
        this.m = new PermutationMatrix(this.dim);
        this.M = new UpperTriangularMatrix(this.dim);
        this.M.set(1, 1, 0.0);
        this.G = new LowerTriangularMatrix(this.dim);
        int n = a2 = 1;
        while (n <= this.dim) {
            this.G.set(a2, a2, 1.0);
            n = ++a2;
        }
        this.H = MatrixUtils.to2DArray(A);
        this.H();
        this.H = null;
    }

    private void H(int a2) {
        double a3;
        Doolittle a4;
        int a5;
        int a6 = a2 - 1;
        int a7 = a2;
        double a8 = Double.NEGATIVE_INFINITY;
        int n = a5 = a2;
        while (n <= a4.dim) {
            double d2;
            a3 = a4.H(a5, a2);
            if (d2 > a8) {
                a7 = a5;
                a8 = a3;
            }
            n = ++a5;
        }
        if (a7 > a2) {
            int n2 = a5 = a6;
            while (n2 < a4.dim) {
                a3 = a4.H[a6][a5];
                a4.H[a6][a5] = a4.H[a7 - 1][a5];
                a4.H[a7 - 1][a5] = a3;
                n2 = ++a5;
            }
            int n3 = a5 = 1;
            while (n3 < a2) {
                a3 = a4.G.get(a2, a5);
                a4.G.set(a2, a5, a4.G.get(a7, a5));
                a4.G.set(a7, a5, a3);
                n3 = ++a5;
            }
            a4.m.swapRow(a7, a2);
        }
    }
}

