/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class LDL {
    private final int G;
    private final Matrix M;
    private DiagonalMatrix m;
    private LowerTriangularMatrix H;

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.H);
    }

    private void H() {
        int a2;
        LDL a3;
        a3.H = new LowerTriangularMatrix(a3.G);
        a3.m = new DiagonalMatrix(a3.G);
        int n = a2 = 1;
        while (n <= a3.G) {
            int a4;
            int a5;
            int n2 = a5 = 1;
            while (n2 < a2) {
                if (DoubleUtils.compare(a3.m.get(a5, a5), 0.0) == 0) {
                    a3.H.set(a2, a5, 0.0);
                } else {
                    int a6;
                    double a7 = a3.M.get(a2, a5);
                    int n3 = a6 = 1;
                    while (true) {
                        if (n3 > a5 - 1) break;
                        a7 -= a3.H.get(a2, a6) * a3.H.get(a5, a6) * a3.m.get(a6, a6);
                        n3 = ++a6;
                    }
                    a3.H.set(a2, a5, a7 /= a3.m.get(a5, a5));
                }
                n2 = ++a5;
            }
            a3.H.set(a2, a2, 1.0);
            double a22 = a3.M.get(a2, a2);
            int n4 = a4 = 1;
            while (true) {
                if (n4 > a2 - 1) break;
                a22 -= a3.H.get(a2, a4) * a3.H.get(a2, a4) * a3.m.get(a4, a4);
                n4 = ++a4;
            }
            a3.m.set(a2, a2, a22);
            n = ++a2;
        }
    }

    public LDL(Matrix A) {
        if (!IsMatrix.symmetric(A)) {
            throw new IllegalArgumentException(b.C("XQ[4tpp{qepgqar{j5fdpyjq\u007f5{{(zexM5Dm]xV`N|\\4UtOfM-"));
        }
        this.G = A.nRows();
        this.M = A;
        this.H();
    }

    public UpperTriangularMatrix Lt() {
        return this.H.t();
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.m);
    }
}

