/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination.GaussianElimination4SquareMatrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Doolittle;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LUDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class LU
implements LUDecomposition {
    private final LUDecomposition H;

    public LU(Matrix A) {
        this(A, Method.DOOLITTLE, SuanShuUtils.autoEpsilon(A));
    }

    public PermutationMatrix P() {
        return this.H.P();
    }

    public UpperTriangularMatrix U() {
        return this.H.U();
    }

    public LU(Matrix A, Method method, double epsilon) {
        switch (method) {
            case GAUSSIAN_ELIMINATION: {
                do {
                } while (false);
                this.H = new GaussianElimination4SquareMatrix(A, epsilon);
                break;
            }
            default: {
                this.H = new Doolittle(A, true, epsilon);
            }
        }
    }

    public LowerTriangularMatrix L() {
        return this.H.L();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GAUSSIAN_ELIMINATION;
        public static final /* enum */ Method DOOLITTLE;
        private static final /* synthetic */ Method[] $VALUES;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        private Method() {
            Method a2;
        }

        static {
            DOOLITTLE = new Method();
            GAUSSIAN_ELIMINATION = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = DOOLITTLE;
            methodArray[1] = GAUSSIAN_ELIMINATION;
            $VALUES = methodArray;
        }
    }
}

