/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.doubles.linearsystem.Solver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class BackwardSubstitution {
    public final UpperTriangularMatrix U;

    public BackwardSubstitution(UpperTriangularMatrix U) {
        this.U = U;
    }

    public Vector solve(Vector b2) {
        int a2;
        SuanShuUtils.assertArgument(this.U.dim() == b2.size(), b.C("w4{`b`2}|b{5m|\u007f5vukp!xg{j`f5hg*@\u0012g\u0016qXyW{N}Q;"));
        int a3 = b2.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = a3;
        while (true) {
            if (n < 1) break;
            a4.set(a2, b2.get(a2));
            int n2 = a2 + 1;
            while (n2 <= a3) {
                int a5;
                a4.set(a2, a4.get(a2) - this.U.get(a2, a5) * a4.get(a5));
                n2 = ++a5;
            }
            if (DoubleUtils.compare(this.U.get(a2, a2), 0.0) != 0) {
                a4.set(a2, a4.get(a2) / this.U.get(a2, a2));
            } else if (DoubleUtils.compare(a4.get(a2), 0.0) != 0) {
                throw new Solver.NoSolution(b.C("zz7g\u007fyf`uzq4lz;`l|t4slp`ix/{n5g}ZpVf\u0010pBa]aV{V&"));
            }
            n = --a2;
        }
        return a4;
    }
}

