/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.ForwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.Solver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LU {
    public final PermutationMatrix P;
    public final LowerTriangularMatrix L;
    private final int H;
    public final UpperTriangularMatrix U;

    public LU(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        this.H = A.nRows();
        try {
            com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU a2 = new com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU(A, LU.Method.DOOLITTLE, 0.0);
            this.L = a2.L();
            this.U = a2.U();
            this.P = a2.P();
        }
        catch (MatrixSingularityException a3) {
            throw new Solver.NoSolution(b.C("zz7g\u007fyf`uzq4lz;`l|t4slp`ix/{n5g}ZpVf\u0010pBa]aV{V&"));
        }
    }

    public Vector solve(Vector b2) {
        SuanShuUtils.assertArgument(this.H == b2.size(), b.C("U2d4t|~qrfv{v5vawa'qq`bx,a`4j2x4XpYsD="));
        Vector a2 = this.P.multiply(b2);
        Vector a3 = new ForwardSubstitution(this.L).solve(a2);
        BackwardSubstitution a4 = new BackwardSubstitution(this.U);
        Vector a5 = a4.solve(a3);
        return a5;
    }
}

