/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.PseudoInverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class OLSSolver {
    public final double epsilon;
    private final int m;
    private final IOLSSolver H;

    public OLSSolver(Matrix A) {
        this(A, Method.QR, SuanShuUtils.autoEpsilon(A));
    }

    public OLSSolver(Matrix A, Method method, double epsilon) {
        this.m = A.nRows();
        this.epsilon = epsilon;
        this.H = method == Method.QR ? new SolveByQR(A) : new SolveBySVD(A);
    }

    public Vector solve(Vector y2) {
        SuanShuUtils.assertArgument(y2.size() == this.m, b.C("m5s{uf3zsa?|yc~4p}b4czqfiv{4dpes@="));
        return this.H.solve(y2);
    }

    private class SolveByQR
    implements IOLSSolver {
        private final UpperTriangularMatrix m;
        private final Matrix H;

        SolveByQR(Matrix a2) {
            SolveByQR a3;
            HouseholderReflection a4 = new HouseholderReflection(a2, a3.OLSSolver.this.epsilon);
            a3.H = a4.squareQ().t();
            a3.m = a4.R();
        }

        public Vector solve(Vector y2) {
            SuanShuUtils.assertArgument(y2.size() == OLSSolver.this.m, b.C("m5s{uf3zsa?|yc~4p}b4czqfiv{4dpes@="));
            Vector a2 = CreateVector.subVector(this.H.multiply(y2), 1, this.m.dim());
            Vector a3 = new BackwardSubstitution(this.m).solve(a2);
            return a3;
        }
    }

    private class SolveBySVD
    implements IOLSSolver {
        private final PseudoInverse H;

        SolveBySVD(Matrix a2) {
            SolveBySVD a3;
            a3.H = new PseudoInverse(a2, a3.OLSSolver.this.epsilon);
        }

        public Vector solve(Vector y2) {
            SuanShuUtils.assertArgument(y2.size() == OLSSolver.this.m, b.C("m5s{uf3zsa?|yc~4p}b4czqfiv{4dpes@="));
            return this.H.multiply(y2);
        }
    }

    private static interface IOLSSolver {
        public Vector solve(Vector var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method QR = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method SVD = new Method();

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        static {
            Method[] methodArray = new Method[2];
            methodArray[0] = QR;
            methodArray[1] = SVD;
            $VALUES = methodArray;
        }
    }
}

