/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.Kernel;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LU;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Solver {
    public final boolean isFullRank;
    public final double epsilon;
    private final Matrix m;
    public final Matrix A;
    public final VectorList basis;
    private final Matrix H;

    public Vector solve(Vector b2) {
        Vector a2;
        SuanShuUtils.assertArgument(this.A.nRows() == b2.size(), b.C("U2d4t|~qrfv{v5vawa'qq`bx,a`4j2x4XpYsD="));
        if (this.isFullRank) {
            LU a3 = new LU(this.A);
            a2 = a3.solve(b2);
        } else if (IsMatrix.zero(b2, this.epsilon)) {
            a2 = new DenseVector(this.A.nCols()).ZERO();
        } else {
            int a4;
            a2 = this.H.multiply(b2);
            int n = a4 = 1;
            while (n <= a2.size()) {
                if (IsMatrix.zero(this.m.getRow(a4), this.epsilon) && DoubleUtils.compare(a2.get(a4), 0.0, this.epsilon) != 0) {
                    throw new NoSolution(b.C("MP_\u0019NAMMTU\u0012VS\u0018ZPG]KK\r]_L@LKVK\u0018OJ9QtZrVmPbLwW!"));
                }
                n = ++a4;
            }
        }
        return a2;
    }

    public Solver(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }

    public Solver(Matrix A, double epsilon) {
        SuanShuUtils.assertArgument(A.nCols() >= A.nRows(), b.C("Um7)0w3}o5~z8zmqv8cqtpqye{jp(frg@pZ:\u0010E_q]fZ4[zUgMqBf\u0000`P}Br\u000f[dF\u000byqa\u007f{t&"));
        this.A = A;
        Kernel a2 = new Kernel(A, Kernel.Method.QR, epsilon);
        this.isFullRank = a2.isZero();
        this.basis = a2.basis();
        this.H = a2.T();
        this.m = a2.U();
        this.epsilon = epsilon;
    }

    public VectorList homogeneousSoln() {
        return new VectorList(this.basis);
    }

    public static class NoSolution
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSolution(String msg) {
            super(msg);
        }
    }
}

