/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GivensMatrix
extends MatrixMathImpl<GivensMatrix> {
    private final int B;
    private final double G;
    private final int M;
    private final int m;
    private final double H;

    public static GivensMatrix CtorToRotateRows(int dim, int row1, int row2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.compare(a5, 0.0) == 0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, row1, row2, a4, a3);
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a2 = new DenseVector(this.M, 0.0);
        a2.set(col, this.get(col, col));
        a2.set(this.B, this.get(this.B, col));
        a2.set(this.m, this.get(this.m, col));
        return a2;
    }

    public Matrix rightMultiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, this);
        DenseMatrix a3 = new DenseMatrix(A);
        int n = a2 = 1;
        while (n <= A.nRows()) {
            double a4 = a3.get(a2, this.B);
            double a5 = a3.get(a2, this.m);
            a3.set(a2, this.B, this.H * a4 - this.G * a5);
            a3.set(a2, this.m, this.G * a4 + this.H * a5);
            n = ++a2;
        }
        return a3;
    }

    public double rho() {
        double a2 = DoubleUtils.compare(this.H, 0.0) == 0 ? 1.0 : (DoubleUtils.compare(Math.abs(this.G), Math.abs(this.H)) < 0 ? Math.signum(this.H) * this.G / 2.0 : 2.0 * Math.signum(this.G) / this.H);
        return a2;
    }

    @Override
    public GivensMatrix t() {
        return new GivensMatrix(this.M, this.B, this.m, this.H, -this.G);
    }

    public static GivensMatrix CtorToZeroOutEntryByTranspose(Matrix A, int i2, int j) {
        double a2 = A.get(i2 == 1 ? A.nRows() : i2 - 1, j);
        double a3 = A.get(i2, j);
        return GivensMatrix.CtorToRotateColumns(A.nRows(), i2 == 1 ? A.nRows() : i2 - 1, i2, a2, a3);
    }

    public static GivensMatrix CtorToZeroOutEntry(Matrix A, int i2, int j) {
        double a2 = A.get(i2 == 1 ? A.nRows() : i2 - 1, j);
        double a3 = A.get(i2, j);
        return GivensMatrix.CtorToRotateRows(A.nRows(), i2 == 1 ? A.nRows() : i2 - 1, i2, a2, a3);
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) {
        throw new MatrixAccessException(b.C("Jexhg\u007fGlq~ou!eq-tasxmmxa0"));
    }

    public static GivensMatrix CtorFromRho(int dim, int i2, int j, double rho) {
        double a2;
        double a3;
        SuanShuUtils.assertArgument(0 < i2, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(0 < j, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(i2 <= dim, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(j <= dim, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(i2 != j, b.C("hnt`iib!zpobdfgbpt{n;"));
        if (DoubleUtils.compare(rho, 1.0) == 0) {
            a3 = 1.0;
            a2 = 0.0;
        } else if (DoubleUtils.compare(Math.abs(rho), 1.0) < 0) {
            a3 = 2.0 * rho;
            a2 = Math.sqrt(1.0 - a3 * a3);
        } else {
            a2 = 2.0 / rho;
            a3 = Math.sqrt(1.0 - a2 * a2);
        }
        return new GivensMatrix(dim, i2, j, a2, a3);
    }

    @Override
    public String toString() {
        Object a2 = new DenseMatrix(this.M, this.M).ONE();
        a2.set(this.B, this.B, this.H);
        a2.set(this.m, this.m, this.H);
        a2.set(this.B, this.m, this.G);
        a2.set(this.m, this.B, -this.G);
        return a2.toString();
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        Vector a2 = v.deepCopy();
        a2.set(this.B, v.get(this.B) * this.H + v.get(this.m) * this.G);
        a2.set(this.m, v.get(this.m) * this.H - v.get(this.B) * this.G);
        return a2;
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a2 = new DenseVector(this.M, 0.0);
        a2.set(row, this.get(row, row));
        a2.set(this.B, this.get(row, this.B));
        a2.set(this.m, this.get(row, this.m));
        return a2;
    }

    public GivensMatrix(int dim, int i2, int j, double c2, double s) {
        super(dim, dim);
        SuanShuUtils.assertArgument(0 < i2, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(0 < j, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(i2 <= dim, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(j <= dim, b.C("oifipudez'iogbgu\u007fh;"));
        SuanShuUtils.assertArgument(i2 != j, b.C("hnt`iib!zpobdfgbpt{n;"));
        this.M = dim;
        this.B = i2;
        this.m = j;
        this.H = c2;
        this.G = s;
    }

    @Override
    public Matrix multiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, A);
        DenseMatrix a3 = new DenseMatrix(A);
        int n = a2 = 1;
        while (n <= A.nCols()) {
            double a4 = a3.get(this.B, a2);
            double a5 = a3.get(this.m, a2);
            a3.set(this.B, a2, this.H * a4 + this.G * a5);
            a3.set(this.m, a2, -this.G * a4 + this.H * a5);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public GivensMatrix ONE() {
        return new GivensMatrix(this.M, 1, 2, 1.0, 0.0);
    }

    public GivensMatrix(GivensMatrix that) {
        this(that.M, that.B, that.m, that.H, that.G);
    }

    @Override
    public GivensMatrix deepCopy() {
        return new GivensMatrix(this);
    }

    @Override
    public double get(int row, int col) {
        if (row == this.B && col == this.B) {
            return this.H;
        }
        if (row == this.m && col == this.m) {
            return this.H;
        }
        if (row == this.B && col == this.m) {
            return this.G;
        }
        if (row == this.m && col == this.B) {
            return -this.G;
        }
        if (row == col) {
            return 1.0;
        }
        return 0.0;
    }

    @Deprecated
    public Vector rotate(Vector x2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static Matrix product(GivensMatrix[] Gs) {
        int a2;
        Object a3 = null;
        int n = a2 = Gs.length - 1;
        while (n >= 0) {
            if (Gs[a2] != null) {
                if (a3 == null) {
                    a3 = new DenseMatrix(Gs[a2].M, Gs[a2].M).ONE();
                }
                a3 = Gs[a2].multiply((Matrix)a3);
            }
            n = --a2;
        }
        return a3;
    }

    public static GivensMatrix CtorToRotateColumns(int dim, int col1, int col2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.compare(a5, 0.0) == 0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, col1, col2, a4, -a3);
    }

    public static GivensMatrix Ctor2x2(double c2, double s) {
        return new GivensMatrix(2, 1, 2, c2, s);
    }

    @Override
    @Deprecated
    public Matrix ZERO() {
        throw new UnsupportedOperationException(b.C("dd)pkyb*ojuxos%luy9Mw}xdaFp~db-"));
    }
}

