/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatrixMathImpl<T extends Matrix>
implements Matrix {
    private final int G;
    private T M = null;
    private final int m;
    private final MatrixMathOperation H;

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a3 = new DenseVector(this.nCols());
        int n = a2 = 1;
        while (n <= a3.length) {
            a3.set(a2, this.get(row, a2));
            n = ++a2;
        }
        return a3;
    }

    protected T getSample() {
        if (this.M == null) {
            this.M = this.ZERO();
        }
        return this.M;
    }

    @Override
    public Matrix minus(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call(b.C("|y|d&"), that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.H.minus(this, that);
    }

    static {
        Package.getInstance(b.C("SQAX\u0016")).validate();
    }

    public void setRow(int row, double ... values) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        if (values.length != this.nCols()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = values.length;
            objectArray[1] = this.nCols();
            throw new MatrixAccessException(String.format(b.C("]@O\tC]CKDZ\u0002FC\bPHU]_Z\u001d\u0000\u001bM\u0018\bVFP[\u0016Gf\\*Dl\\mA!\\jL%KiElEt\tnAdL1\u00007M|"), objectArray));
        }
        int n = a2 = 1;
        while (n <= values.length) {
            this.set(row, a2, values[a2 - 1]);
            n = ++a2;
        }
    }

    @Override
    public int nRows() {
        return this.m;
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a3 = new DenseVector(this.nRows());
        int n = a2 = 1;
        while (n <= a3.length) {
            a3.set(a2, this.get(a2, col));
            n = ++a2;
        }
        return a3;
    }

    public MatrixMathImpl(int nRows, int nCols, MatrixMathOperation math) {
        this.m = nRows;
        this.G = nCols;
        this.H = math;
    }

    @Override
    public Matrix scaled(double scalar) {
        return this.H.scaled(this, scalar);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.m;
        objectArray[1] = this.G;
        a3.append(String.format(b.C("1qo1t_"), objectArray));
        a3.append(b.C("\\"));
        int n = a2 = 1;
        while (n <= this.G) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a3.append(String.format(b.C("O92pMu"), objectArray2));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 1;
        while (n2 <= this.m) {
            int a4;
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = a2;
            a3.append(String.format(b.C("O0s8Mu"), objectArray3));
            int n3 = a4 = 1;
            while (n3 <= this.G) {
                Object[] objectArray4 = new Object[1];
                objectArray4[0] = this.get(a2, a4);
                a3.append(String.format(b.C("0r:u"), objectArray4));
                n3 = ++a4;
            }
            a3.append("\n");
            n2 = ++a2;
        }
        return a3.toString();
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix add(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call(b.C("ws1"), that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.H.add(this, that);
    }

    public T call(String op, Matrix that) throws NoSuchMethodException, IllegalAccessException {
        try {
            Class<?> a2 = this.getSample().getClass();
            Class[] classArray = new Class[1];
            classArray[0] = a2;
            Object[] objectArray = new Object[1];
            objectArray[0] = that;
            Matrix a3 = (Matrix)a2.getDeclaredMethod(op, classArray).invoke((Object)this, objectArray);
            return (T)a3;
        }
        catch (InvocationTargetException a4) {
            throw (RuntimeException)a4.getCause();
        }
    }

    @Override
    public Matrix t() {
        return this.H.transpose(this);
    }

    public void setRow(int row, Vector v) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        int a3 = v.size();
        if (a3 != this.nCols()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = this.nCols();
            throw new MatrixAccessException(String.format(b.C("]@O\tC]CKDZ\u0002FC\bPHU]_Z\u001d\u0000\u001bM\u0018\bVFP[\u0016Gf\\*Dl\\mA!\\jL%KiElEt\tnAdL1\u00007M|"), objectArray));
        }
        int n = a2 = 1;
        while (n <= a3) {
            this.set(row, a2, v.get(a2));
            n = ++a2;
        }
    }

    @Override
    public Matrix multiply(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call(b.C("xazaxd~,"), that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.H.multiply((Matrix)this, that);
    }

    public MatrixMathImpl(int nRows, int nCols) {
        this(nRows, nCols, new SimpleMatrixMathOperation());
    }

    @Override
    public int nCols() {
        return this.G;
    }

    public void setColumn(int col, Vector v) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a3 = v.size();
        if (a3 != this.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = this.nRows();
            throw new MatrixAccessException(String.format(b.C("`}r4~`~vyg?{~5muh`bg =&p%5k{mf+z[a\u0017yQaP|\u001caWq\u0018gTc\u0004fNnE5\u000b1H|"), objectArray));
        }
        int n = a2 = 1;
        while (n <= a3) {
            this.set(a2, col, v.get(a2));
            n = ++a2;
        }
    }

    @Override
    public Vector multiply(Vector v) {
        return this.H.multiply((Matrix)this, v);
    }

    public void setColumn(int col, double ... values) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (values.length != this.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = values.length;
            objectArray[1] = this.nRows();
            throw new MatrixAccessException(String.format(b.C("`}r4~`~vyg?{~5muh`bg =&p%5k{mf+z[a\u0017yQaP|\u001caWq\u0018gTc\u0004fNnE5\u000b1H|"), objectArray));
        }
        int n = a2 = 1;
        while (n <= values.length) {
            this.set(a2, col, values[a2 - 1]);
            n = ++a2;
        }
    }
}

