/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationMatrix
extends MatrixMathImpl<PermutationMatrix> {
    private final int M;
    private int m = 1;
    private int[] H;

    public double sign() {
        return Math.signum(this.m);
    }

    @Override
    public Vector multiply(Vector v) {
        int a2;
        double[] a3 = new double[v.size()];
        int n = a2 = 0;
        while (n < a3.length) {
            a3[a2] = v.get(this.H[a2 + 1]);
            n = ++a2;
        }
        DenseVector denseVector = new DenseVector(a3);
        return denseVector;
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException(b.C("mP[\\JY\u001aHFY\u0016NF]BoBK\u000eR[\u001cYJDLeRMIOS=UpNmY{Y{"));
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a2 = new DenseVector(this.M);
        a2.set(this.H[row], 1.0);
        return a2;
    }

    public Matrix rightMultiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, this);
        Vector[] a3 = new Vector[A.nCols()];
        int n = a2 = 1;
        while (n <= A.nCols()) {
            a3[this.H[a2] - 1] = A.getColumn(a2);
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.cbind(a3);
        return denseMatrix;
    }

    public PermutationMatrix(int dim) {
        super(dim, dim);
        int a2;
        this.M = dim;
        this.H = new int[dim + 1];
        int n = a2 = 0;
        while (n <= dim) {
            this.H[a2] = a2;
            n = ++a2;
        }
    }

    public void moveRow2End(int row) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        int a3 = this.H[row];
        int n = a2 = row;
        while (n < this.nRows()) {
            this.H[a2] = this.H[a2 + 1];
            n = ++a2;
        }
        this.H[this.nRows()] = a3;
    }

    @Override
    public Matrix multiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, A);
        Vector[] a3 = new Vector[A.nRows()];
        int n = a2 = 0;
        while (n < A.nRows()) {
            a3[a2] = A.getRow(this.H[a2 + 1]);
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.rbind(a3);
        return denseMatrix;
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a3 = new DenseVector(this.M);
        int n = a2 = 1;
        while (n <= this.M) {
            if (this.H[a2] == col) {
                a3.set(a2, 1.0);
                break;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, row);
        double a2 = 0.0;
        if (this.H[row] == col) {
            a2 = 1.0;
        }
        return a2;
    }

    public PermutationMatrix(PermutationMatrix P) {
        super(P.M, P.M);
        this.M = P.M;
        this.H = Arrays.copyOf(P.H, P.H.length);
        this.m = P.m;
    }

    @Override
    public Matrix scaled(double scalar) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.M, this.M);
        int n = a2 = 1;
        while (n < this.H.length) {
            a3.set(a2, this.H[a2], scalar);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix ZERO() {
        throw new UnsupportedOperationException(b.C("EQDXD@SAT[P\u0015TUNGLL\u0006V@ZLZY\u0014LP\tNOG:"));
    }

    public void swapColumn(int col1, int col2) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col1);
        DimensionCheck.throwIfInvalidColumn(this, col2);
        int n = a2 = 1;
        while (n <= this.M) {
            if (this.H[a2] == col1) {
                this.H[a2] = col2;
            } else if (this.H[a2] == col2) {
                this.H[a2] = col1;
            }
            n = ++a2;
        }
        this.m *= -1;
    }

    public void moveColumn2End(int col) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        int n = a2 = 1;
        while (n <= this.nRows()) {
            if (this.H[a2] == col) {
                this.H[a2] = this.nCols();
            } else if (this.H[a2] > col) {
                int n2 = a2;
                this.H[n2] = this.H[n2] - 1;
            }
            n = ++a2;
        }
    }

    @Override
    public Matrix minus(Matrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a3 = new DenseMatrix(that);
        int n = a2 = 1;
        while (n < this.H.length) {
            a3.set(a2, this.H[a2], 1.0 - a3.get(a2, this.H[a2]));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public PermutationMatrix deepCopy() {
        return new PermutationMatrix(this);
    }

    @Override
    public PermutationMatrix t() {
        int a2;
        PermutationMatrix a3 = new PermutationMatrix(this.M);
        int n = a2 = 1;
        while (n <= this.M) {
            a3.H[this.H[a2]] = a2;
            n = ++a2;
        }
        return a3;
    }

    public PermutationMatrix(int[] data) {
        super(data.length, data.length);
        int a2;
        int a3;
        this.M = data.length;
        this.H = new int[this.M + 1];
        boolean[] a4 = new boolean[this.M + 1];
        int n = a3 = 1;
        while (n <= this.M) {
            this.H[a3] = a2 = data[a3 - 1];
            a4[a2] = true;
            n = ++a3;
        }
        a3 = 1;
        int n2 = a2 = 1;
        while (n2 <= this.M) {
            a3 &= a4[a2];
            n2 = ++a2;
        }
        if (a3 == 0) {
            throw new IllegalArgumentException(b.C("qubt1}a5s{j5x4jpwysa``kzc4ct}fc-"));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermutationMatrix) && obj instanceof Matrix) {
            return AreMatrices.equal(this, (Matrix)obj, 0.0);
        }
        PermutationMatrix a2 = (PermutationMatrix)obj;
        if (this.M != a2.M) {
            return false;
        }
        if (!(this.H == a2.H || this.H != null && Arrays.equals(this.H, a2.H))) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.M;
        a2 = 59 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    public void swapRow(int row1, int row2) {
        DimensionCheck.throwIfInvalidRow(this, row1);
        DimensionCheck.throwIfInvalidRow(this, row2);
        int a2 = this.H[row1];
        this.H[row1] = this.H[row2];
        this.H[row2] = a2;
        this.m *= -1;
    }

    @Override
    public Matrix add(Matrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a3 = new DenseMatrix(that);
        int n = a2 = 1;
        while (n < this.H.length) {
            a3.set(a2, this.H[a2], 1.0 + a3.get(a2, this.H[a2]));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public PermutationMatrix ONE() {
        return new PermutationMatrix(this.M);
    }
}

