/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.CompositeDoubleArrayOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.DoubleArrayOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.ParallelDoubleArrayOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleDoubleArrayOperation;
import com.numericalmethod.suanshu.number.DoubleUtils;

public abstract class DenseData
implements MatrixData {
    private static final int m = 10000;
    private final DoubleArrayOperation H;
    protected double[] data = null;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DenseData a2 = (DenseData)obj;
        if (!(this.data == a2.data || this.data != null && DoubleUtils.equal(this.data, a2.data, 0.0))) {
            return false;
        }
        return true;
    }

    public double[] add(DenseData that) {
        return this.H.add(this.data, that.data);
    }

    public double[] minus(DenseData that) {
        return this.H.minus(this.data, that.data);
    }

    public DenseData(int length) {
        this(new double[length]);
    }

    public double[] scaled(double scalar) {
        return this.H.scaled(this.data, scalar);
    }

    public DenseData(double[] data) {
        this(data, new CompositeDoubleArrayOperation(10000, new SimpleDoubleArrayOperation(), new ParallelDoubleArrayOperation()));
    }

    public DenseData(double[] data, DoubleArrayOperation doubleArrayOperation) {
        this.H = doubleArrayOperation;
        this.data = data;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 59 * a2 + (this.data != null ? this.data.hashCode() : 0);
        return a2;
    }
}

