/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixStorageImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.parallel.LoopBody;
import com.numericalmethod.suanshu.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseMatrix
extends MatrixStorageImpl<DenseMatrix>
implements Densifiable {
    private final ParallelExecutor m = new ParallelExecutor();
    private static final int H = 10000;

    @Override
    public DenseMatrix scaled(double scalar) {
        return new DenseMatrix(this.getMatrixData().scaled(scalar), this.nRows(), this.nCols());
    }

    public DenseMatrix(DenseMatrix A) {
        this(A.nRows(), A.nCols(), (MyDenseDataImpl)A.getMatrixData().deepCopy());
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols());
    }

    @Override
    public DenseMatrix toDense() {
        return this;
    }

    @Override
    public Vector getRow(int row) {
        return this.getRow(row, 1, this.nCols());
    }

    @Override
    public DenseMatrix minus(DenseMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new DenseMatrix(this.getMatrixData().minus(that.getMatrixData()), this.nRows(), this.nCols());
    }

    @Override
    public Vector multiply(final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        final int a2 = this.nCols();
        final double[] a3 = this.getDataArray();
        final double[] a4 = new double[this.nRows()];
        try {
            this.m.conditionalForLoop(a4.length >= 10000, 0, a4.length, 1, new LoopBody(){
                {
                    3 a22;
                }

                public void run(int i2) throws Exception {
                    int a22;
                    double a32 = 0.0;
                    int n = a22 = 0;
                    while (n < v.size()) {
                        a32 += a3[i2 * a2 + a22] * v.get(a22 + 1);
                        n = ++a22;
                    }
                    a4[i2] = a32;
                }
            });
        }
        catch (MultipleExecutionException a5) {
            throw new RuntimeException(a5);
        }
        DenseVector a6 = new DenseVector(a4);
        return a6;
    }

    public DenseMatrix(double[] data, int nRows, int nCols) {
        this(nRows, nCols, new MyDenseDataImpl(data, nCols));
    }

    @Override
    protected DenseData getMatrixData() {
        return (DenseData)super.getMatrixData();
    }

    double[] getDataArray() {
        DenseMatrix a2;
        return a2.getMatrixData().data;
    }

    @Override
    public DenseMatrix deepCopy() {
        return new DenseMatrix(this);
    }

    public Vector getColumn(int col, int beginRow, int endRow) {
        int a2;
        block6: {
            block5: {
                int a3 = this.nRows();
                a2 = this.nCols();
                if (col < 1) {
                    throw new IllegalArgumentException(b.C("sou.foj!jo\u007foys.gco\u007f!d"));
                }
                if (col > a2) break block5;
                if (beginRow < 1 || beginRow > a3) break block5;
                if (endRow >= 1 && endRow <= a3) break block6;
            }
            throw new IllegalArgumentException(b.C("pvlxqqz9xvv|-"));
        }
        double[] a4 = this.getDataArray();
        double[] a5 = new double[endRow - beginRow + 1];
        int a6 = 0;
        int a7 = col - 1 + (beginRow - 1) * a2;
        int n = a6;
        while (n <= endRow - beginRow) {
            a5[a6] = a4[a7];
            a7 += a2;
            n = ++a6;
        }
        return new DenseVector(a5);
    }

    public DenseMatrix(int nRows, int nCols) {
        this(nRows, nCols, new MyDenseDataImpl(nRows, nCols));
    }

    @Override
    public DenseMatrix t() {
        final int a2 = this.nRows();
        final int a3 = this.nCols();
        final double[] a4 = this.getDataArray();
        final double[] a5 = new double[a4.length];
        try {
            this.m.conditionalForLoop(a4.length >= 10000, 0, a2, new LoopBody(){
                {
                    2 a22;
                }

                public void run(int i2) throws Exception {
                    int a22 = i2 * a3;
                    int a32 = 0;
                    int a42 = 0;
                    int n = a32;
                    while (n < a3) {
                        a5[i2 + a42] = a4[a22 + a32];
                        a42 += a2;
                        n = ++a32;
                    }
                }
            });
        }
        catch (MultipleExecutionException a6) {
            throw new RuntimeException(a6);
        }
        DenseMatrix a7 = new DenseMatrix(a5, a3, a2);
        return a7;
    }

    protected void overwrite(Matrix A) {
        DenseMatrix a2 = null;
        a2 = A instanceof DenseMatrix ? (DenseMatrix)A : new DenseMatrix(A);
        this.setMatrixData((MyDenseDataImpl)a2.getMatrixData().deepCopy());
    }

    @Override
    public Vector getColumn(int col) {
        return this.getColumn(col, 1, this.nRows());
    }

    private DenseMatrix(int a2, int a3, MyDenseDataImpl a4) {
        super(a2, a3, a4);
        DenseMatrix a5;
    }

    public DenseMatrix(Vector v) {
        this(v.toArray(), v.size(), 1);
    }

    @Override
    protected DenseMatrix getSample() {
        return new DenseMatrix(1, 1).ZERO();
    }

    public DenseMatrix(double[][] data) {
        this(data.length, data[0].length);
        int a2;
        int a3 = this.nRows();
        int a4 = this.nCols();
        double[] a5 = this.getDataArray();
        int a6 = 0;
        int n = a2 = 1;
        while (n <= a3) {
            int a7;
            if (data[a2 - 1].length != a4) {
                this.setMatrixData(null);
                throw new IllegalArgumentException(b.C("qubt1}a5|4tt~s\u007fq%utg`m95`uep)g\u007fgP4B}P`\u0012tQx\u001egVcI5MuPp\u0001`Jp\rgOxL4Fp{sb="));
            }
            int n2 = a7 = 1;
            while (n2 <= a4) {
                int n3 = a6++;
                a5[n3] = data[a2 - 1][a7 - 1];
                n2 = ++a7;
            }
            n = ++a2;
        }
    }

    @Override
    public DenseMatrix multiply(DenseMatrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, that);
        Matrix a2 = that.t();
        final double[] a3 = this.getDataArray();
        final double[] a4 = ((DenseMatrix)a2).getDataArray();
        final double[] a5 = new double[this.nRows() * that.nCols()];
        final int a6 = this.nCols();
        final int a7 = that.nCols();
        try {
            this.m.conditionalForLoop(a3.length >= 10000, 0, a3.length, a6, new LoopBody(){
                {
                    1 a2;
                }

                public void run(int i2) throws Exception {
                    int a2;
                    int a32 = i2 / a6 * a7;
                    int a42 = i2 + a6;
                    int n = a2 = 0;
                    while (n < a4.length) {
                        double a52 = 0.0;
                        int a62 = i2;
                        int a72 = a2;
                        int n2 = a62;
                        while (n2 < a42) {
                            a52 += a3[a62] * a4[a72];
                            ++a72;
                            n2 = ++a62;
                        }
                        a5[a32++] = a52;
                        n = a2 + a6;
                    }
                }
            });
        }
        catch (MultipleExecutionException a8) {
            throw new RuntimeException(a8);
        }
        DenseMatrix a9 = new DenseMatrix(a5, this.nRows(), that.nCols());
        return a9;
    }

    @Override
    public DenseMatrix add(DenseMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new DenseMatrix(this.getMatrixData().add(that.getMatrixData()), this.nRows(), this.nCols());
    }

    @Override
    public DenseMatrix ONE() {
        int a2;
        int a3 = this.nCols();
        double[] a4 = new double[this.nRows() * a3];
        int n = a2 = 0;
        double[] dArray = a4;
        for (int a5 = 0; n < dArray.length && a5 < a3; ++a5) {
            a4[a2 + a5] = 1.0;
            n = a2 + a3;
            dArray = a4;
        }
        DenseMatrix a22 = new DenseMatrix(a4, this.nRows(), a3);
        return a22;
    }

    public Vector getRow(int row, int beginCol, int endCol) {
        int a2;
        block5: {
            block4: {
                a2 = this.nCols();
                if (row < 1) {
                    throw new IllegalArgumentException(b.C("sou.foj!jo\u007foys.gco\u007f!d"));
                }
                if (row > this.nRows()) break block4;
                if (beginCol < 1 || beginCol > a2) break block4;
                if (endCol >= 1 && endCol <= a2) break block5;
            }
            throw new IllegalArgumentException(b.C("pvlxqqz9xvv|-"));
        }
        double[] a3 = null;
        int a4 = a2 * (row - 1);
        a3 = Arrays.copyOfRange(this.getDataArray(), a4 + beginCol - 1, a4 + endCol);
        return new DenseVector(a3);
    }

    public DenseMatrix(Matrix A) {
        this(A.nRows(), A.nCols());
        int a2;
        int a3 = A.nRows();
        int a4 = A.nCols();
        double[] a5 = this.getDataArray();
        int a6 = 0;
        int n = a2 = 1;
        while (n <= a3) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4) {
                a5[a6++] = A.get(a2, a7);
                n2 = ++a7;
            }
            n = ++a2;
        }
    }

    private static class MyDenseDataImpl
    extends DenseData {
        private final int H;

        MyDenseDataImpl(int a2, int a3) {
            super(a2 * a3);
            MyDenseDataImpl a4;
            a4.H = a3;
        }

        MyDenseDataImpl(double[] a2, int a3) {
            super(a2);
            MyDenseDataImpl a4;
            a4.H = a3;
        }

        public double get(int row, int col) {
            if (this.data == null) {
                return 0.0;
            }
            return this.data[(row - 1) * this.H + (col - 1)];
        }

        public MyDenseDataImpl deepCopy() {
            return new MyDenseDataImpl(Arrays.copyOf(this.data, this.data.length), this.H);
        }

        public void set(int row, int col, double value) {
            this.data[(row - 1) * this.H + (col - 1)] = value;
        }
    }
}

