/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

class DiagonalData
implements MatrixData,
Densifiable {
    final int dim;
    final Type type;
    private double[][] H;

    private void e(double[] a2) {
        DiagonalData a3;
        a3.H[2] = new double[a3.dim - 1];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim - 1, b.C("qubt1gwa=}m5w{n5vad8e}crbzo9"));
            System.arraycopy(a2, 0, a3.H[2], 0, a3.dim - 1);
        }
    }

    public DiagonalData deepCopy() {
        return new DiagonalData(this);
    }

    private void C(double[] a2) {
        DiagonalData a3;
        a3.H[1] = new double[a3.dim];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim, b.C("qubt1gwa=}m5w{n5a}grnzc9"));
            System.arraycopy(a2, 0, a3.H[1], 0, a3.dim);
        }
    }

    double[] diagonal() {
        DiagonalData a2;
        return Arrays.copyOf(a2.H[1], a2.H[1].length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(int row, int col, double value) {
        if (row == col - 1) {
            if (this.H[0] != null) {
                this.H[0][row - 1] = value;
                return;
            }
        }
        if (row == col) {
            this.H[1][row - 1] = value;
            return;
        }
        if (row == col + 1) {
            if (this.H[2] != null) {
                this.H[2][row - 2] = value;
                return;
            }
        }
        if (DoubleUtils.compare(0.0, value) == 0) return;
        Object[] objectArray = new Object[2];
        objectArray[0] = row;
        objectArray[1] = col;
        throw new IllegalArgumentException(String.format(b.C("T['eX[#eT cr-abvpya!e"), objectArray));
    }

    DiagonalData minus(DiagonalData a2) {
        int a3;
        DiagonalData a4;
        a4.H(a4, a2);
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.H[a3] != null) {
                int a6;
                int a7 = a4.H[a3].length;
                a5.H[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.H[a3][a6] = a4.H[a3][a6] - a2.H[a3][a6];
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.dim, this.dim);
        a2.set(1, 1, this.get(1, 1));
        if (this.dim >= 2) {
            int a3;
            a2.set(1, 2, this.get(1, 2));
            int n = a3 = 2;
            while (n < this.dim) {
                a2.set(a3, a3 - 1, this.get(a3, a3 - 1));
                a2.set(a3, a3, this.get(a3, a3));
                a2.set(a3, a3 + 1, this.get(a3, a3 + 1));
                n = ++a3;
            }
            a2.set(this.dim, this.dim, this.get(this.dim, this.dim));
            a2.set(this.dim, this.dim - 1, this.get(this.dim, this.dim - 1));
        }
        return a2;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 47 * a2 + this.dim;
        a2 = 47 * a2 + (this.H != null ? this.H.hashCode() : 0);
        a2 = 47 * a2 + (this.type != null ? this.type.hashCode() : 0);
        return a2;
    }

    public double get(int row, int col) {
        if (this.H == null) {
            return 0.0;
        }
        double a2 = row == col - 1 ? (this.H[0] != null ? this.H[0][row - 1] : 0.0) : (row == col ? (this.H[1] != null ? this.H[1][row - 1] : 0.0) : (row == col + 1 ? (this.H[2] != null ? this.H[2][row - 2] : 0.0) : 0.0));
        return a2;
    }

    private boolean H(DiagonalData a2, DiagonalData a3) {
        if (a2.type != a3.type) {
            throw new IllegalArgumentException(b.C("A\\S\u0015EC]\u0015YUJT\u0019G_A\u0005UTP\u0001ZMA\r@FP\tGKX0"));
        }
        return true;
    }

    public String toString() {
        return this.toDense().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagonalData a2 = (DiagonalData)obj;
        if (this.dim != a2.dim) {
            return false;
        }
        if (this.H != a2.H) {
            int a3;
            int n = a3 = 0;
            while (true) {
                if (n >= 3) break;
                if (this.H[a3] != null && a2.H[a3] != null ? !DoubleUtils.equal(this.H[a3], a2.H[a3], 0.0) : (this.H[a3] == null ? a2.H[a3] != null && !DoubleUtils.allZeros(a2.H[a3], 0.0) : a2.H[a3] == null && !DoubleUtils.allZeros(this.H[a3], 0.0))) {
                    return false;
                }
                n = ++a3;
            }
        }
        return true;
    }

    DiagonalData scaled(double a2) {
        int a3;
        DiagonalData a4;
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.H[a3] != null) {
                int a6;
                int a7 = a4.H[a3].length;
                a5.H[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.H[a3][a6] = a4.H[a3][a6] * a2;
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    DiagonalData(DiagonalData a2) {
        DiagonalData a3;
        a3.H = null;
        a3.dim = a2.dim;
        a3.type = a2.type;
        (a3.H = (double[][])new double[3][])[0] = a2.H[0] != null ? Arrays.copyOf(a2.H[0], a2.H[0].length) : null;
        a3.H[1] = a2.H[1] != null ? Arrays.copyOf(a2.H[1], a2.H[1].length) : null;
        a3.H[2] = a2.H[2] != null ? Arrays.copyOf(a2.H[2], a2.H[2].length) : null;
    }

    DiagonalData opposite() {
        DiagonalData a2;
        return a2.scaled(-1.0);
    }

    DiagonalData(Type a2, int a3) {
        DiagonalData a4;
        a4.H = null;
        a4.dim = a3;
        a4.type = a2;
        a4.H = new double[3][];
        switch (a2) {
            case TRI_DIAGONAL: {
                a4.H[0] = new double[a3 - 1];
                a4.H[1] = new double[a3];
                a4.H[2] = new double[a3 - 1];
                break;
            }
            case BI_DIAGONAL_UPPER: {
                a4.H[0] = new double[a3 - 1];
                a4.H[1] = new double[a3];
                break;
            }
            case BI_DIAGONAL_LOWER: {
                a4.H[1] = new double[a3];
                a4.H[2] = new double[a3 - 1];
                break;
            }
            case DIAGONAL: {
                do {
                } while (false);
                a4.H[1] = new double[a3];
            }
        }
    }

    DiagonalData(double[][] a2) {
        DiagonalData a3;
        a3.H = null;
        a3.H = new double[3][];
        switch (a2.length) {
            case 1: {
                a3.type = Type.DIAGONAL;
                a3.dim = a2[0].length;
                a3.C(a2[0]);
                break;
            }
            case 2: {
                if (a2[0].length > a2[1].length) {
                    a3.type = Type.BI_DIAGONAL_LOWER;
                    a3.dim = a2[0].length;
                    a3.C(a2[0]);
                    a3.e(a2[1]);
                    break;
                }
                a3.type = Type.BI_DIAGONAL_UPPER;
                a3.dim = a2[1].length;
                a3.H(a2[0]);
                a3.C(a2[1]);
                break;
            }
            case 3: {
                do {
                } while (false);
                a3.type = Type.TRI_DIAGONAL;
                a3.dim = a2[1].length;
                a3.H(a2[0]);
                a3.C(a2[1]);
                a3.e(a2[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException(b.C("|z`t}}v5yujt9g\u007f!"));
            }
        }
    }

    DiagonalData add(DiagonalData a2) {
        int a3;
        DiagonalData a4;
        a4.H(a4, a2);
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.H[a3] != null) {
                int a6;
                int a7 = a4.H[a3].length;
                a5.H[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.H[a3][a6] = a4.H[a3][a6] + a2.H[a3][a6];
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    double[] superDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.H[0] != null ? Arrays.copyOf(a2.H[0], a2.H[0].length) : new double[a2.dim - 1];
        return a3;
    }

    double[] subDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.H[2] != null ? Arrays.copyOf(a2.H[2], a2.H[2].length) : new double[a2.dim - 1];
        return a3;
    }

    private void H(double[] a2) {
        DiagonalData a3;
        a3.H[0] = new double[a3.dim - 1];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim - 1, b.C("ptcu0fv`<|l4vzo4w`wqr8g}mr`zi9"));
            System.arraycopy(a2, 0, a3.H[0], 0, a3.dim - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BI_DIAGONAL_LOWER;
        public static final /* enum */ Type BI_DIAGONAL_UPPER;
        public static final /* enum */ Type DIAGONAL;
        public static final /* enum */ Type TRI_DIAGONAL;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        private Type() {
            Type a2;
        }

        static {
            TRI_DIAGONAL = new Type();
            BI_DIAGONAL_UPPER = new Type();
            BI_DIAGONAL_LOWER = new Type();
            DIAGONAL = new Type();
            Type[] typeArray = new Type[4];
            typeArray[0] = TRI_DIAGONAL;
            typeArray[1] = BI_DIAGONAL_UPPER;
            typeArray[2] = BI_DIAGONAL_LOWER;
            typeArray[3] = DIAGONAL;
            $VALUES = typeArray;
        }
    }
}

