/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import com.numericalmethod.suanshu.misc.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TridiagonalMatrix
extends DiagonalDataMatrix<TridiagonalMatrix> {
    @Override
    public TridiagonalMatrix ONE() {
        double[][] a2 = new double[3][];
        int a3 = this.diagonalData.dim;
        a2[0] = R.rep(0.0, a3 - 1);
        a2[1] = R.rep(1.0, a3);
        a2[2] = R.rep(0.0, a3 - 1);
        return new TridiagonalMatrix(a2);
    }

    @Override
    public TridiagonalMatrix minus(TridiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.minus(that.diagonalData);
        return new TridiagonalMatrix(a2);
    }

    public TridiagonalMatrix(double[][] data) {
        this(TridiagonalMatrix.H(data));
    }

    @Override
    public TridiagonalMatrix t() {
        double[][] dArrayArray = new double[3][];
        double[][] a2 = dArrayArray;
        dArrayArray[0] = this.diagonalData.subDiagonal();
        a2[1] = this.diagonalData.diagonal();
        a2[2] = this.diagonalData.superDiagonal();
        return new TridiagonalMatrix(a2);
    }

    public TridiagonalMatrix(int dim) {
        this(new DiagonalData(DiagonalData.Type.TRI_DIAGONAL, dim));
    }

    private TridiagonalMatrix(DiagonalData a2) {
        super(a2);
        TridiagonalMatrix a3;
    }

    @Override
    public TridiagonalMatrix ZERO() {
        return new TridiagonalMatrix(this.diagonalData.dim);
    }

    @Deprecated
    private TridiagonalMatrix H(TridiagonalMatrix a2) {
        throw new UnsupportedOperationException(b.C("nIP^WZZU\\Z]wWOGSI^Z\u001aJT\rTMO\u0001YIUVNsOlN{\u001b|\u001a_T\u007fU\u007f_{"));
    }

    @Override
    public TridiagonalMatrix scaled(double scalar) {
        DiagonalData a2 = this.diagonalData.scaled(scalar);
        return new TridiagonalMatrix(a2);
    }

    @Override
    public TridiagonalMatrix deepCopy() {
        return new TridiagonalMatrix(this);
    }

    private static DiagonalData H(double[][] a2) {
        if (a2.length != 3) {
            throw new IllegalArgumentException(b.C("af\u007fqxuuzsur5tungll&q``c5`a}a)|kcP4\u00055C{E&"));
        }
        int a3 = 0;
        if (a2[0] != null) {
            a3 = a2[0].length + 1;
        } else if (a2[1] != null) {
            a3 = a2[1].length;
        } else if (a2[2] != null) {
            a3 = a2[2].length + 1;
        } else {
            throw new IllegalArgumentException(b.C("F[T@S\u0013XGIG\u0019P[\u0013\\F\u0002_DSUG\u0005]DV\t\\A]\u0000\\g_}\u0012d\\\""));
        }
        double[][] dArrayArray = new double[3][];
        double[][] a4 = dArrayArray;
        dArrayArray[0] = a2[0] != null ? a2[0] : R.rep(0.0, a3 - 1);
        a4[1] = a2[1] != null ? a2[1] : R.rep(0.0, a3);
        a4[2] = a2[2] != null ? a2[2] : R.rep(0.0, a3 - 1);
        return new DiagonalData(a4);
    }

    public TridiagonalMatrix(TridiagonalMatrix that) {
        this((DiagonalData)that.diagonalData.deepCopy());
    }

    @Override
    public TridiagonalMatrix add(TridiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.add(that.diagonalData);
        return new TridiagonalMatrix(a2);
    }
}

