/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.MatrixAccessor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixStorageImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricMatrix
extends MatrixStorageImpl<SymmetricMatrix>
implements Densifiable {
    public final int dim;
    private LowerTriangularMatrix H;

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            this.H.set(col, row, value);
        } else {
            this.H.set(row, col, value);
        }
    }

    @Override
    public int hashCode() {
        int a2 = 3;
        a2 = 17 * a2 + this.dim;
        a2 = 17 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    @Override
    public SymmetricMatrix scaled(double scalar) {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).H = this.H.scaled(scalar);
        return a2;
    }

    @Override
    public SymmetricMatrix deepCopy() {
        return new SymmetricMatrix(this);
    }

    private SymmetricMatrix(LowerTriangularMatrix a2) {
        super(a2.dim(), a2.dim(), a2.getMatrixData());
        SymmetricMatrix a3;
        a3.dim = a2.dim();
        a3.H = a2;
    }

    public SymmetricMatrix(double[][] data) {
        this(new LowerTriangularMatrix(data));
    }

    @Override
    public String toString() {
        return this.toDense().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SymmetricMatrix) && obj instanceof MatrixAccessor) {
            return AreMatrices.equal(this, (Matrix)obj, 0.0);
        }
        SymmetricMatrix a2 = (SymmetricMatrix)obj;
        if (this.dim != a2.dim) {
            return false;
        }
        if (!(this.H == a2.H || this.H != null && this.H.equals(a2.H))) {
            return false;
        }
        return true;
    }

    public SymmetricMatrix(SymmetricMatrix S) {
        this(S.H);
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            return this.H.get(col, row);
        }
        return this.H.get(row, col);
    }

    @Override
    public DenseVector getColumn(int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.getRow(col);
    }

    @Override
    public SymmetricMatrix ZERO() {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).H = this.H.ZERO();
        return a2;
    }

    @Override
    public SymmetricMatrix t() {
        return this;
    }

    public SymmetricMatrix(int dim) {
        this(new LowerTriangularMatrix(dim));
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        DenseMatrix a3 = this.H.toDense();
        int n = a2 = 1;
        while (n <= this.dim) {
            int n2 = a2 + 1;
            while (n2 <= this.dim) {
                int a4;
                a3.set(a2, a4, this.H.get(a4, a2));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public DenseVector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        double[] a3 = this.H.getRow(row).toArray();
        double[] a4 = this.H.getColumn(row).toArray();
        double[] a5 = new double[this.dim];
        int a6 = 0;
        int n = a2 = 0;
        while (true) {
            if (n >= row - 1) break;
            a5[a6++] = a3[a2];
            n = ++a2;
        }
        int n2 = a2 = row - 1;
        while (n2 < this.dim) {
            a5[a6++] = a4[a2];
            n2 = ++a2;
        }
        return new DenseVector(a5);
    }

    @Override
    public SymmetricMatrix minus(SymmetricMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).H = this.H.minus(that.H);
        return a2;
    }

    @Override
    public SymmetricMatrix ONE() {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).H = this.H.ONE();
        return a2;
    }

    @Override
    public SymmetricMatrix add(SymmetricMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).H = this.H.add(that.H);
        return a2;
    }
}

