/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class SimpleMatrixMathOperation
implements MatrixMathOperation {
    public Vector multiply(Matrix A, Vector v) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, v);
        DenseVector a3 = new DenseVector(A.nRows());
        int n = a2 = 1;
        while (n <= a3.length) {
            int a4;
            double a5 = 0.0;
            int n2 = a4 = 1;
            while (n2 <= v.size()) {
                a5 += A.get(a2, a4) * v.get(a4);
                n2 = ++a4;
            }
            a3.set(a2, a5);
            n = ++a2;
        }
        return a3;
    }

    public Matrix add(Matrix A1, Matrix A2) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        DenseMatrix a3 = new DenseMatrix(A1.nRows(), A1.nCols());
        int n = a2 = 1;
        while (n <= A1.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A1.nCols()) {
                a3.set(a2, a4, A1.get(a2, a4) + A2.get(a2, a4));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public Matrix scaled(Matrix A, double scalar) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(A.nRows(), A.nCols());
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                a3.set(a2, a4, A.get(a2, a4) * scalar);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public Matrix minus(Matrix A1, Matrix A2) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        DenseMatrix a3 = new DenseMatrix(A1.nRows(), A1.nCols());
        int n = a2 = 1;
        while (n <= A1.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A1.nCols()) {
                a3.set(a2, a4, A1.get(a2, a4) - A2.get(a2, a4));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public Matrix transpose(Matrix A) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(A.nCols(), A.nRows());
        int n = a2 = 1;
        while (n <= A.nCols()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nRows()) {
                a3.set(a2, a4, A.get(a4, a2));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public Matrix multiply(Matrix A1, Matrix A2) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A1, A2);
        DenseMatrix a3 = new DenseMatrix(A1.nRows(), A2.nCols());
        int n = a2 = 1;
        while (n <= a3.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= a3.nCols()) {
                int a5;
                double a6 = 0.0;
                int n3 = a5 = 1;
                while (n3 <= A1.nCols()) {
                    a6 += A1.get(a2, a5) * A2.get(a5, a4);
                    n3 = ++a5;
                }
                a3.set(a2, a4, a6);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }
}

