/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

abstract class AbstractSparseMatrix
implements SparseMatrix {
    protected final int nRows;
    private final MatrixMathOperation H;
    protected final int nCols;

    AbstractSparseMatrix(int a2, int a3) {
        block3: {
            block2: {
                AbstractSparseMatrix a4;
                a4.H = new SimpleMatrixMathOperation();
                if (a2 < 1) break block2;
                if (a3 >= 1) break block3;
            }
            throw new IllegalArgumentException(b.C("XUBGXL\u0012QTY[[J]U[\u0005YSFU\u0014@P\rDAF@@CC0"));
        }
        a4.nRows = a2;
        a4.nCols = a3;
    }

    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    public int nRows() {
        return this.nRows;
    }

    public Matrix scaled(double scalar) {
        return this.H.scaled(this, scalar);
    }

    public Matrix add(Matrix that) {
        return this.H.add(this, that);
    }

    public Vector multiply(Vector v) {
        return this.H.multiply((Matrix)this, v);
    }

    public Matrix multiply(Matrix that) {
        return this.H.multiply((Matrix)this, that);
    }

    public int nCols() {
        return this.nCols;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSparseMatrix a2 = (AbstractSparseMatrix)obj;
        if (this.nRows != a2.nRows) {
            return false;
        }
        if (this.nCols != a2.nCols) {
            return false;
        }
        if (this.nnz() != a2.nnz()) {
            return false;
        }
        List<SparseElement> a3 = this.toElementList();
        List<SparseElement> a4 = a2.toElementList();
        Collections.sort(a3, SparseElement.TopLeftFirstComparator.INSTANCE);
        Collections.sort(a4, SparseElement.TopLeftFirstComparator.INSTANCE);
        ListIterator<SparseElement> a5 = a3.listIterator();
        ListIterator<SparseElement> a6 = a4.listIterator();
        boolean a7 = a5.hasNext();
        boolean a8 = a6.hasNext();
        boolean bl = a7;
        while (bl && a8) {
            if (!((SparseElement)a5.next()).equals(a6.next())) {
                return false;
            }
            a7 = a5.hasNext();
            a8 = a6.hasNext();
            bl = a7;
        }
        if (a7 != a8) {
            return false;
        }
        return true;
    }

    public Matrix minus(Matrix that) {
        return this.H.minus(this, that);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 79 * a2 + this.nRows;
        a2 = 79 * a2 + this.nCols;
        return a2;
    }

    public String toString() {
        Iterator<SparseElement> a2;
        List<SparseElement> a3 = this.toElementList();
        StringBuilder a4 = new StringBuilder();
        a4.append(this.nRows).append(b.C("-")).append(this.nCols).append(b.C("2}\u007fh6.u")).append(this.nnz()).append("\n");
        Iterator<SparseElement> iterator = a2 = a3.iterator();
        while (iterator.hasNext()) {
            SparseElement a5 = a2.next();
            a4.append(b.C("}")).append(a5.coordinates.i).append(b.C("8u")).append(a5.coordinates.j).append(b.C("?-u")).append(a5.value).append("\n");
            iterator = a2;
        }
        return a4.toString();
    }

    public Matrix t() {
        return this.H.transpose(this);
    }
}

