/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.AbstractSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.Coordinates;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.LilSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsrSparseMatrix
extends AbstractSparseMatrix {
    private int G;
    private int[] M;
    private double[] m;
    private int[] H;

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        SparseVector a3 = new SparseVector(this.nRows);
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.M[a2 - 1];
            while (n2 < this.M[a2]) {
                int a4;
                if (this.H[a4] == col) {
                    a3.set(a2, this.m[a4]);
                }
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    private void C() {
        CsrSparseMatrix a2;
        a2.H(new CheckForKeepValue(){
            {
                2 a2;
            }

            public boolean toKeep(double value) {
                return Double.compare(0.0, value) != 0;
            }
        });
    }

    public CsrSparseMatrix(int nRows, int nCols) {
        this(nRows, nCols, true);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof CsrSparseMatrix) {
            return this.H((CsrSparseMatrix)that);
        }
        return super.multiply(that);
    }

    @Override
    public Vector multiply(Vector v) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        Vector a3 = v instanceof SparseVector ? new SparseVector(this.nRows) : new DenseVector(this.nRows);
        int n = a2 = 1;
        while (n <= this.nRows) {
            a3.set(a2, this.getRow(a2).innerProduct(v));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix ZERO() {
        return new CsrSparseMatrix(this.nRows, this.nCols);
    }

    @Override
    public int nnz() {
        return this.G;
    }

    public CsrSparseMatrix(int nRows, int nCols, List<SparseElement> elementList) {
        super(nRows, nCols);
        Iterator<SparseElement> a2;
        this.G = 0;
        this.M = null;
        this.H = null;
        this.m = null;
        Collections.sort(elementList, SparseElement.TopLeftFirstComparator.INSTANCE);
        this.G = elementList.size();
        this.m = new double[this.G];
        this.H = new int[this.G];
        int[] a3 = new int[nRows + 1];
        int a4 = 0;
        Iterator<SparseElement> iterator = a2 = elementList.iterator();
        while (iterator.hasNext()) {
            SparseElement a5;
            block4: {
                block3: {
                    a5 = a2.next();
                    Coordinates a6 = a5.coordinates;
                    if (a6.i < 1 || a6.i > nRows) break block3;
                    if (a6.j >= 1 && a6.j <= nCols) break block4;
                }
                throw new IllegalArgumentException(b.C("zab8~r?g|zyp9qvphqha!wmz\u007fpg{h`o&"));
            }
            this.m[a4] = a5.value;
            this.H[a4] = a5.coordinates.j;
            ++a4;
            int n = a5.coordinates.i;
            a3[n] = a3[n] + 1;
            iterator = a2;
        }
        this.M = R.cumsum(a3);
    }

    @Override
    public int dropTolerance(final double tolerance) {
        int a2 = this.G;
        this.H(new CheckForKeepValue(){
            {
                1 a2;
            }

            public boolean toKeep(double value) {
                return Double.compare(Math.abs(value), tolerance) > 0;
            }
        });
        return a2 - this.G;
    }

    @Override
    public List<SparseElement> toElementList() {
        int a2;
        ArrayList<SparseElement> a3 = new ArrayList<SparseElement>(this.nnz());
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.M[a2 - 1];
            while (n2 < this.M[a2]) {
                int a4;
                a3.add(new SparseElement(new Coordinates(a2, this.H[a4]), this.m[a4]));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public CsrSparseMatrix deepCopy() {
        return new CsrSparseMatrix(this);
    }

    @Override
    public Matrix scaled(double scalar) {
        int a2;
        if (Double.compare(0.0, scalar) == 0) {
            return new CsrSparseMatrix(this.nRows, this.nCols);
        }
        CsrSparseMatrix a3 = new CsrSparseMatrix(this);
        int n = a2 = 0;
        while (n < a3.m.length) {
            int n2 = a2++;
            a3.m[n2] = a3.m[n2] * scalar;
            n = a2;
        }
        return a3;
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        SparseVector a3 = new SparseVector(this.nCols);
        int n = a2 = this.M[row - 1];
        while (n < this.M[row]) {
            a3.set(this.H[a2], this.m[a2]);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix ONE() {
        int a2 = Math.min(this.nRows, this.nCols);
        double[] a3 = R.rep(1.0, a2);
        int[] a4 = R.seq(1, a2);
        int[] a5 = R.seq(1, a2);
        return new CsrSparseMatrix(this.nRows, this.nCols, a4, a5, a3);
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.M[row - 1];
        int a3 = this.M[row];
        int a4 = 0;
        int n = a4 = a2;
        while (n < a3 && this.H[a4] != col) {
            n = ++a4;
        }
        return a4 == a3 ? 0.0 : this.m[a4];
    }

    private CsrSparseMatrix H(CsrSparseMatrix a2) {
        int a3;
        CsrSparseMatrix a4;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)a4, a2);
        CsrSparseMatrix a5 = new CsrSparseMatrix(a4.nRows, a2.nCols, false);
        new CsrSparseMatrix(a4.nRows, a2.nCols, false).M = new int[a4.nRows + 1];
        double[] a6 = new double[a4.nnz() + a2.nnz()];
        int[] a7 = new int[a4.nnz() + a2.nnz()];
        int a8 = 0;
        Scatter a9 = new Scatter(a2.nCols);
        int n = a3 = 1;
        while (n <= a4.nRows) {
            if (a8 + a2.nCols > a6.length) {
                a6 = Arrays.copyOf(a6, 2 * a6.length + a2.nCols);
                a7 = Arrays.copyOf(a7, 2 * a7.length + a2.nCols);
            }
            a5.M[a3 - 1] = a8;
            a9.H(a3);
            int n2 = a4.M[a3 - 1];
            while (n2 < a4.M[a3]) {
                int a10;
                a9.H(a2, a4.H[a10], a4.m[a10]);
                n2 = ++a10;
            }
            a8 += a9.H(a6, a7, a8);
            n = ++a3;
        }
        a5.M[a4.nRows] = a8;
        a5.G = a8;
        a5.m = Arrays.copyOf(a6, a8);
        a5.H = Arrays.copyOf(a7, a8);
        a5.C();
        a5.H();
        return a5;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof CsrSparseMatrix) {
            return this.H((CsrSparseMatrix)that, 1.0);
        }
        return super.add(that);
    }

    private void H(CheckForKeepValue a2) {
        CsrSparseMatrix a3;
        int a4;
        int a5 = 0;
        int n = a4 = 0;
        while (n < a3.nRows) {
            int a6 = a3.M[a4];
            a3.M[a4] = a5;
            int n2 = a6;
            while (true) {
                if (n2 >= a3.M[a4 + 1]) break;
                if (a2.toKeep(a3.m[a6])) {
                    a3.m[a5] = a3.m[a6];
                    a3.H[a5] = a3.H[a6];
                    ++a5;
                }
                n2 = ++a6;
            }
            n = ++a4;
        }
        a3.M[a3.nRows] = a5;
        a3.m = Arrays.copyOf(a3.m, a5);
        a3.H = Arrays.copyOf(a3.H, a5);
        a3.G = a5;
    }

    public CsrSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        super(nRows, nCols);
        int a2;
        this.G = 0;
        this.M = null;
        this.H = null;
        this.m = null;
        SuanShuUtils.assertArgument(rowIndices.length == columnIndices.length && rowIndices.length == values.length, b.C("}{gad5rfntfg8frna5j}sxb`o="));
        this.G = values.length;
        this.m = new double[values.length];
        this.H = new int[values.length];
        this.M = new int[nRows + 1];
        LilSparseMatrix a3 = new LilSparseMatrix(nRows, nCols, rowIndices, columnIndices, values);
        this.M[0] = 0;
        SparseVector a4 = null;
        int a5 = 0;
        int n = a2 = 1;
        while (n <= nRows) {
            a4 = (SparseVector)a3.getRow(a2);
            Iterator<SparseVector.Entry> iterator = a4.iterator();
            while (iterator.hasNext()) {
                Iterator<SparseVector.Entry> a6;
                SparseVector.Entry a7 = a6.next();
                this.m[a5] = a7.value();
                this.H[a5] = a7.index();
                ++a5;
                iterator = a6;
            }
            this.M[a2] = a5;
            n = ++a2;
        }
    }

    private CsrSparseMatrix(int a2, int a3, boolean a4) {
        super(a2, a3);
        CsrSparseMatrix a5;
        a5.G = 0;
        a5.M = null;
        a5.H = null;
        a5.m = null;
        a5.G = 0;
        if (a4) {
            a5.m = new double[0];
            a5.H = new int[0];
            a5.M = new int[a2 + 1];
        }
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof CsrSparseMatrix) {
            return this.H((CsrSparseMatrix)that, -1.0);
        }
        return super.minus(that);
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows, this.nCols);
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.M[a2 - 1];
            while (n2 < this.M[a2]) {
                int a4;
                a3.set(a2, this.H[a4], this.m[a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix t() {
        int a2;
        CsrSparseMatrix a3 = new CsrSparseMatrix(this.nCols, this.nRows, false);
        double[] a4 = new double[this.m.length];
        int[] a5 = new int[this.H.length];
        int[] a6 = new int[this.nCols + 1];
        int n = a2 = 0;
        while (n < this.H.length) {
            int n2 = this.H[a2];
            a6[n2] = a6[n2] + 1;
            n = ++a2;
        }
        a6 = R.cumsum(a6);
        a3.M = (int[])a6.clone();
        int n3 = a2 = 1;
        while (n3 <= this.nRows) {
            int n4 = this.M[a2 - 1];
            while (n4 < this.M[a2]) {
                int a7;
                int n5 = this.H[a7] - 1;
                a6[n5] = a6[n5] + 1;
                a5[a] = a2;
                a4[a] = this.m[a7];
                n4 = ++a7;
            }
            n3 = ++a2;
        }
        a3.m = a4;
        a3.H = a5;
        return a3;
    }

    private CsrSparseMatrix H(CsrSparseMatrix a2, double a3) {
        int a4;
        CsrSparseMatrix a5;
        DimensionCheck.throwIfDifferentDimension(a5, a2);
        CsrSparseMatrix a6 = new CsrSparseMatrix(a5.nRows, a5.nCols, false);
        new CsrSparseMatrix(a5.nRows, a5.nCols, false).M = new int[a5.nRows + 1];
        double[] a7 = new double[a5.nnz() + a2.nnz()];
        int[] a8 = new int[a5.nnz() + a2.nnz()];
        int a9 = 0;
        Scatter a10 = new Scatter(a5.nCols);
        int n = a4 = 1;
        while (n <= a5.nRows) {
            a6.M[a4 - 1] = a9;
            a10.H(a4);
            a10.H(a5, a4, 1.0);
            a10.H(a2, a4, a3);
            a9 += a10.H(a7, a8, a9);
            n = ++a4;
        }
        a6.M[a5.nRows] = a9;
        a6.G = a9;
        a6.m = Arrays.copyOf(a7, a9);
        a6.H = Arrays.copyOf(a8, a9);
        a6.C();
        a6.H();
        return a6;
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.M[row - 1];
        int a3 = this.M[row];
        int a4 = 0;
        int n = a4 = a2;
        while (n < a3 && this.H[a4] < col) {
            n = ++a4;
        }
        if (a4 != a3 && this.H[a4] == col) {
            if (value != 0.0) {
                this.m[a4] = value;
            } else {
                int a5;
                double[] a6 = this.m;
                this.m = new double[a6.length - 1];
                System.arraycopy(a6, 0, this.m, 0, a4);
                System.arraycopy(a6, a4 + 1, this.m, a4, this.m.length - a4);
                int[] a7 = this.H;
                this.H = new int[a7.length - 1];
                System.arraycopy(a7, 0, this.H, 0, a4);
                System.arraycopy(a7, a4 + 1, this.H, a4, this.H.length - a4);
                int n2 = a5 = row;
                while (n2 < this.M.length) {
                    int n3 = a5++;
                    this.M[n3] = this.M[n3] - 1;
                    n2 = a5;
                }
                --this.G;
            }
        } else {
            int a8;
            double[] a9 = this.m;
            this.m = new double[a9.length + 1];
            System.arraycopy(a9, 0, this.m, 0, a4);
            System.arraycopy(a9, a4, this.m, a4 + 1, a9.length - a4);
            this.m[a4] = value;
            int[] a10 = this.H;
            this.H = new int[a10.length + 1];
            System.arraycopy(a10, 0, this.H, 0, a4);
            System.arraycopy(a10, a4, this.H, a4 + 1, a10.length - a4);
            this.H[a4] = col;
            int n4 = a8 = row;
            while (n4 < this.M.length) {
                int n5 = a8++;
                this.M[n5] = this.M[n5] + 1;
                n4 = a8;
            }
            ++this.G;
        }
    }

    private void H() {
        CsrSparseMatrix a2;
        a2.t().t();
    }

    public CsrSparseMatrix(CsrSparseMatrix that) {
        super(that.nRows, that.nCols);
        this.G = 0;
        this.M = null;
        this.H = null;
        this.m = null;
        this.G = that.G;
        this.m = (double[])that.m.clone();
        this.H = (int[])that.H.clone();
        this.M = (int[])that.M.clone();
    }

    private static interface CheckForKeepValue {
        public boolean toKeep(double var1);
    }

    private static class Scatter {
        private int[] B;
        private int G;
        private double[] M;
        private final int[] m;
        private int H;

        private void H(int a2) {
            Scatter a3;
            a3.G = a2;
            Arrays.fill(a3.B, 0, a3.H, 0);
            a3.H = 0;
        }

        private void H(CsrSparseMatrix a2, int a3, double a4) {
            int a5;
            int n = a5 = a2.M[a3 - 1];
            while (n < a2.M[a3]) {
                Scatter a6;
                int a7 = a2.H[a5];
                if (a6.m[a7 - 1] < a6.G) {
                    a6.m[a7 - 1] = a6.G;
                    int n2 = a6.H;
                    a6.H = n2 + 1;
                    a6.B[n2] = a7;
                    a6.M[a7 - 1] = 0.0;
                }
                int n3 = a7 - 1;
                a6.M[n3] = a6.M[n3] + a4 * a2.m[a5];
                n = ++a5;
            }
        }

        private int H(double[] a2, int[] a3, int a4) {
            int a5;
            Scatter a6;
            System.arraycopy(a6.B, 0, a3, a4, a6.H);
            int n = a5 = 0;
            while (n < a6.H) {
                a2[a4 + a5] = a6.M[a6.B[a5] - 1];
                n = ++a5;
            }
            return a6.H;
        }

        private Scatter(int a2) {
            Scatter a3;
            a3.m = new int[a2];
            a3.B = new int[a2];
            a3.M = new double[a2];
        }
    }
}

