/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.AbstractSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.Coordinates;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DokSparseMatrix
extends AbstractSparseMatrix {
    private final HashMap<Coordinates, Double> H;

    private DokSparseMatrix C(DokSparseMatrix a2) {
        DokSparseMatrix a3;
        return a3.H(a2, 1);
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, that);
        int a2 = that.nCols();
        Densifiable a3 = that instanceof SparseMatrix ? new DokSparseMatrix(this.nRows, a2) : new DenseMatrix(this.nRows, a2);
        for (Map.Entry<Coordinates, Double> a4 : this.H.entrySet()) {
            int a5;
            int a6 = a4.getKey().i;
            int a7 = a4.getKey().j;
            double a8 = a4.getValue();
            int n = a5 = 1;
            while (n <= a2) {
                a3.set(a6, a5, a3.get(a6, a5) + a8 * that.get(a7, a5));
                n = ++a5;
            }
        }
        return a3;
    }

    @Override
    public Matrix ZERO() {
        return new DokSparseMatrix(this.nRows, this.nCols);
    }

    public DokSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        super(nRows, nCols);
        int a2;
        SuanShuUtils.assertArgument(rowIndices.length == columnIndices.length && rowIndices.length == values.length, b.C("}{gad5rfntfg8frna5j}sxb`o="));
        this.H = new HashMap(values.length);
        int n = a2 = 0;
        while (n < rowIndices.length) {
            this.H(rowIndices[a2], columnIndices[a2], values[a2]);
            n = ++a2;
        }
    }

    @Override
    public Vector multiply(Vector v) {
        Iterator<Map.Entry<Coordinates, Double>> a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        Vector a3 = v instanceof SparseVector ? new SparseVector(this.nRows) : new DenseVector(this.nRows);
        Iterator<Map.Entry<Coordinates, Double>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coordinates, Double> a4 = a2.next();
            double a5 = a4.getValue() * v.get(a4.getKey().j);
            int a6 = a4.getKey().i;
            a3.set(a6, a3.get(a6) + a5);
            iterator = a2;
        }
        return a3;
    }

    public DokSparseMatrix(int nRows, int nCols) {
        super(nRows, nCols);
        this.H = new HashMap(0);
    }

    @Override
    public DokSparseMatrix deepCopy() {
        return new DokSparseMatrix(this);
    }

    @Override
    public List<SparseElement> toElementList() {
        Iterator<Map.Entry<Coordinates, Double>> a2;
        ArrayList<SparseElement> a3 = new ArrayList<SparseElement>(this.nnz());
        Iterator<Map.Entry<Coordinates, Double>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coordinates, Double> a4 = a2.next();
            a3.add(new SparseElement(a4.getKey(), a4.getValue()));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Matrix t() {
        Iterator<Map.Entry<Coordinates, Double>> a2;
        DokSparseMatrix a3 = new DokSparseMatrix(this.nCols, this.nRows);
        Iterator<Map.Entry<Coordinates, Double>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coordinates, Double> a4 = a2.next();
            Coordinates a5 = a4.getKey();
            a3.set(a5.j, a5.i, a4.getValue());
            iterator = a2;
        }
        return a3;
    }

    public DokSparseMatrix(DokSparseMatrix that) {
        super(that.nRows, that.nCols);
        this.H = new HashMap<Coordinates, Double>(that.H);
    }

    private DokSparseMatrix H(DokSparseMatrix a2, int a3) {
        DokSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        DokSparseMatrix a5 = new DokSparseMatrix(a4);
        for (Map.Entry<Coordinates, Double> a6 : a2.H.entrySet()) {
            Coordinates a7 = a6.getKey();
            Double a8 = a5.H.get(a7);
            a8 = a8 == null ? (double)a3 * a6.getValue() : a8 + (double)a3 * a6.getValue();
            if (Double.compare(0.0, a8) != 0) {
                a5.H.put(a7, a8);
                continue;
            }
            a5.H.remove(a7);
        }
        return a5;
    }

    public DokSparseMatrix(int nRows, int nCols, List<SparseElement> elementList) {
        super(nRows, nCols);
        Iterator<SparseElement> a2;
        Collections.sort(elementList, SparseElement.TopLeftFirstComparator.INSTANCE);
        this.H = new HashMap(elementList.size());
        Iterator<SparseElement> iterator = a2 = elementList.iterator();
        while (iterator.hasNext()) {
            SparseElement a3 = a2.next();
            this.H(a3.coordinates.i, a3.coordinates.j, a3.value);
            iterator = a2;
        }
    }

    private void H(int a2, int a3, double a4) {
        DokSparseMatrix a5;
        DimensionCheck.throwIfInvalidRow(a5, a2);
        DimensionCheck.throwIfInvalidColumn(a5, a3);
        if (Double.compare(0.0, a4) != 0) {
            a5.H.put(new Coordinates(a2, a3), a4);
        } else {
            a5.H.remove(new Coordinates(a2, a3));
        }
    }

    @Override
    public Matrix scaled(double scalar) {
        Iterator<Map.Entry<Coordinates, Double>> a2;
        if (Double.compare(0.0, scalar) == 0) {
            return new DokSparseMatrix(this.nRows, this.nCols);
        }
        DokSparseMatrix a3 = new DokSparseMatrix(this.nRows, this.nCols);
        Iterator<Map.Entry<Coordinates, Double>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coordinates, Double> a4 = a2.next();
            a3.H.put(a4.getKey(), scalar * a4.getValue());
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof DokSparseMatrix) {
            return this.C((DokSparseMatrix)that);
        }
        return super.add(that);
    }

    @Override
    public int dropTolerance(double tolerance) {
        int a2 = 0;
        Iterator<Map.Entry<Coordinates, Double>> a3 = this.H.entrySet().iterator();
        while (a3.hasNext()) {
            if (Double.compare(Math.abs(a3.next().getValue()), tolerance) > 0) continue;
            a3.remove();
            ++a2;
        }
        return a2;
    }

    @Override
    public DenseMatrix toDense() {
        Iterator<Map.Entry<Coordinates, Double>> a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows, this.nCols);
        Iterator<Map.Entry<Coordinates, Double>> iterator = a2 = this.H.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coordinates, Double> a4 = a2.next();
            Coordinates a5 = a4.getKey();
            a3.set(a5.i, a5.j, a4.getValue());
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof DokSparseMatrix) {
            return this.H((DokSparseMatrix)that);
        }
        return super.minus(that);
    }

    @Override
    public int nnz() {
        return this.H.size();
    }

    @Override
    public void set(int row, int col, double value) {
        this.H(row, col, value);
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        Double a2 = this.H.get(new Coordinates(row, col));
        return a2 == null ? 0.0 : a2;
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, col);
        SparseVector a2 = new SparseVector(this.nRows);
        for (Map.Entry<Coordinates, Double> a3 : this.H.entrySet()) {
            if (a3.getKey().j != col) continue;
            a2.set(a3.getKey().i, a3.getValue());
        }
        return a2;
    }

    private DokSparseMatrix H(DokSparseMatrix a2) {
        DokSparseMatrix a3;
        return a3.H(a2, -1);
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        SparseVector a2 = new SparseVector(this.nCols);
        for (Map.Entry<Coordinates, Double> a3 : this.H.entrySet()) {
            if (a3.getKey().i != row) continue;
            a2.set(a3.getKey().j, a3.getValue());
        }
        return a2;
    }

    @Override
    public Matrix ONE() {
        int a2 = Math.min(this.nRows, this.nCols);
        double[] a3 = R.rep(1.0, a2);
        int[] a4 = R.seq(1, a2);
        int[] a5 = R.seq(1, a2);
        return new DokSparseMatrix(this.nRows, this.nCols, a4, a5, a3);
    }
}

