/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.Coordinates;
import java.util.Comparator;

public final class SparseElement {
    public final Coordinates coordinates;
    public final double value;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseElement a2 = (SparseElement)obj;
        if (!(this.coordinates == a2.coordinates || this.coordinates != null && this.coordinates.equals(a2.coordinates))) {
            return false;
        }
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(a2.value)) {
            return false;
        }
        return true;
    }

    public SparseElement(Coordinates coordinates, double value) {
        this.coordinates = coordinates;
        this.value = value;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 83 * a2 + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        a2 = 83 * a2 + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TopLeftFirstComparator
    extends Enum<TopLeftFirstComparator>
    implements Comparator<SparseElement> {
        public static final /* enum */ TopLeftFirstComparator INSTANCE = new TopLeftFirstComparator();
        private static final /* synthetic */ TopLeftFirstComparator[] $VALUES;

        public static TopLeftFirstComparator[] values() {
            return (TopLeftFirstComparator[])$VALUES.clone();
        }

        private TopLeftFirstComparator() {
            TopLeftFirstComparator a2;
        }

        static {
            TopLeftFirstComparator[] topLeftFirstComparatorArray = new TopLeftFirstComparator[1];
            topLeftFirstComparatorArray[0] = INSTANCE;
            $VALUES = topLeftFirstComparatorArray;
        }

        @Override
        public int compare(SparseElement o1, SparseElement o2) {
            if (o1.coordinates.i < o2.coordinates.i) {
                return -1;
            }
            if (o1.coordinates.i > o2.coordinates.i) {
                return 1;
            }
            if (o1.coordinates.j < o2.coordinates.j) {
                return -1;
            }
            if (o1.coordinates.j > o2.coordinates.j) {
                return 1;
            }
            return 0;
        }

        public static TopLeftFirstComparator valueOf(String name) {
            return Enum.valueOf(TopLeftFirstComparator.class, name);
        }
    }
}

