/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseStructure;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.vector.doubles.IsVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseVector
implements Vector,
Iterable<Entry>,
SparseStructure {
    private final int m;
    private final LinkedList<Entry> H;

    public SparseVector(int size) {
        this.m = size;
        this.H = new LinkedList();
    }

    @Override
    public double innerProduct(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.innerProduct((SparseVector)that);
        }
        IsVector.equalSize(this, that);
        double a3 = 0.0;
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3 += a4.H * that.get(a4.m);
            iterator = a2;
        }
        return a3;
    }

    @Override
    public void set(int index, double value) {
        if (index < 1 || index > this.m) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.m;
            objectArray[1] = index;
            throw new IllegalArgumentException(String.format(b.C("f}~$bn#{`fel%S73<lG)tfzli22,1"), objectArray));
        }
        ListIterator<Entry> a2 = this.H.listIterator();
        while (a2.hasNext()) {
            Entry a3 = (Entry)a2.next();
            if (a3.m == index) {
                if (Double.compare(0.0, value) != 0) {
                    a3.H = value;
                } else {
                    a2.remove();
                }
                return;
            }
            if (a3.m <= index) continue;
            if (Double.compare(0.0, value) != 0) {
                a2.previous();
                a2.add(new Entry(index, value));
            }
            return;
        }
        this.H.addLast(new Entry(index, value));
    }

    @Override
    public Vector scaled(Real scalar) {
        return this.scaled(scalar.doubleValue());
    }

    @Override
    double innerProduct(SparseVector a2) {
        SparseVector a3;
        IsVector.equalSize(a3, a2);
        double a4 = 0.0;
        java.util.Iterator a5 = a3.H.iterator();
        java.util.Iterator a6 = a2.H.iterator();
        Entry a7 = a5.hasNext() ? (Entry)a5.next() : null;
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry entry = a7;
        while (entry != null && a8 != null) {
            if (a7.m < a8.m) {
                entry = a7 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            if (a7.m > a8.m) {
                a8 = a6.hasNext() ? (Entry)a6.next() : null;
                entry = a7;
                continue;
            }
            a4 += a7.H * a8.H;
            a7 = a5.hasNext() ? (Entry)a5.next() : null;
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            entry = a7;
        }
        return a4;
    }

    @Override
    public Vector minus(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.H((SparseVector)that, -1);
        }
        IsVector.equalSize(this, that);
        Vector a3 = that.opposite();
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.m, a4.H + a3.get(a4.m));
            iterator = a2;
        }
        return a3;
    }

    private SparseVector(int a2, LinkedList<Entry> a3) {
        SparseVector a4;
        a4.m = a2;
        a4.H = a3;
    }

    @Override
    public Vector ZERO() {
        return new SparseVector(this.m);
    }

    @Override
    public Vector add(double scalar) {
        java.util.Iterator a2;
        double[] a3 = R.rep(scalar, this.m);
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            int n = a4.m - 1;
            a3[n] = a3[n] + a4.H;
            iterator = a2;
        }
        return new DenseVector(a3);
    }

    public SparseVector(SparseVector that) {
        this(that.m);
        java.util.Iterator a2;
        java.util.Iterator iterator = a2 = that.H.iterator();
        while (iterator.hasNext()) {
            Entry a3 = (Entry)a2.next();
            this.H.add(new Entry(a3.m, a3.H));
            iterator = a2;
        }
    }

    public SparseVector(int size, int[] indices, double[] values) {
        int a2;
        int a3;
        if (indices.length != values.length) {
            throw new IllegalArgumentException(b.C("g|mqc5|r<|qdma;uvgfms5n}\u007fxn`k="));
        }
        this.m = size;
        Entry[] a4 = new Entry[values.length];
        int n = a3 = 0;
        while (n < values.length) {
            if (indices[a3] < 1 || indices[a3] > size) {
                throw new IndexOutOfBoundsException(b.C("zab8~r?g|zyp9}tq`l<u") + indices[a3]);
            }
            a4[a3] = new Entry(indices[a3], values[a3]);
            n = ++a3;
        }
        Arrays.sort(a4, new Comparator<Entry>(){
            {
                1 a2;
            }

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.m < o2.m ? -1 : 1;
            }
        });
        this.H = new LinkedList();
        a3 = 0;
        int n2 = a2 = 0;
        while (n2 < a4.length) {
            if (a3 >= a4[a2].m) {
                throw new IllegalArgumentException(b.C("qafyxwsaxp>|wpsv`g<u") + a4[a2].m);
            }
            a3 = a4[a2].m;
            this.H.add(a4[a2]);
            n2 = ++a2;
        }
    }

    private SparseVector H(SparseVector a2, int a3) {
        SparseVector a4;
        IsVector.equalSize(a4, a2);
        LinkedList<Entry> a5 = new LinkedList<Entry>();
        java.util.Iterator a6 = a4.H.iterator();
        java.util.Iterator a7 = a2.H.iterator();
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry a9 = a7.hasNext() ? (Entry)a7.next() : null;
        Entry entry = a8;
        while (entry != null || a9 != null) {
            if (a8 != null && (a9 == null || a8.m < a9.m)) {
                a5.add(new Entry(a8.m, a8.H));
                entry = a8 = a6.hasNext() ? (Entry)a6.next() : null;
                continue;
            }
            if (a9 != null && (a8 == null || a8.m > a9.m)) {
                a5.add(new Entry(a9.m, (double)a3 * a9.H));
                a9 = a7.hasNext() ? (Entry)a7.next() : null;
                entry = a8;
                continue;
            }
            double a10 = a8.H + (double)a3 * a9.H;
            if (Double.compare(0.0, a10) != 0) {
                a5.add(new Entry(a8.m, a10));
            }
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            a9 = a7.hasNext() ? (Entry)a7.next() : null;
            entry = a8;
        }
        return new SparseVector(a4.m, a5);
    }

    @Override
    SparseVector add(SparseVector a2) {
        SparseVector a3;
        return a3.H(a2, 1);
    }

    @Override
    public Vector scaled(double scalar) {
        java.util.Iterator a2;
        if (Double.compare(0.0, scalar) == 0) {
            return new SparseVector(this.m);
        }
        LinkedList<Entry> a3 = new LinkedList<Entry>();
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.add(new Entry(a4.m, scalar * a4.H));
            iterator = a2;
        }
        return new SparseVector(this.m, a3);
    }

    @Override
    public double[] toArray() {
        java.util.Iterator a2;
        double[] a3 = R.rep(0.0, this.m);
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3[((Entry)a4).m - 1] = a4.H;
            iterator = a2;
        }
        return a3;
    }

    @Override
    public int dropTolerance(double tolerance) {
        int a2 = 0;
        java.util.Iterator a3 = this.H.iterator();
        while (a3.hasNext()) {
            if (Double.compare(Math.abs(((Entry)a3.next()).H), tolerance) > 0) continue;
            a3.remove();
            ++a2;
        }
        return a2;
    }

    @Override
    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    @Override
    public Vector divide(Vector that) {
        java.util.Iterator a2;
        IsVector.equalSize(this, that);
        SparseVector a3 = new SparseVector(this);
        java.util.Iterator iterator = a2 = a3.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.m, a4.H / that.get(a4.m));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public int size() {
        return this.m;
    }

    @Override
    public double get(int index) {
        if (index < 1 || index > this.m) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.m;
            objectArray[1] = index;
            throw new IllegalArgumentException(String.format(b.C("f}~$bn#{`fel%S73<lG)tfzli22,1"), objectArray));
        }
        for (Entry a2 : this.H) {
            if (a2.m == index) {
                return a2.H;
            }
            if (a2.m <= index) continue;
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public java.util.Iterator<Entry> iterator() {
        return new Iterator(this.H.listIterator());
    }

    @Override
    public Vector pow(double scalar) {
        java.util.Iterator a2;
        double a3 = Math.pow(0.0, scalar);
        if (Double.compare(0.0, a3) != 0) {
            java.util.Iterator a4;
            double[] a5 = R.rep(a3, this.m);
            java.util.Iterator iterator = a4 = this.H.iterator();
            while (iterator.hasNext()) {
                Entry a6 = (Entry)a4.next();
                a5[((Entry)a6).m - 1] = Math.pow(a6.H, scalar);
                iterator = a4;
            }
            return new DenseVector(a5);
        }
        LinkedList<Entry> a7 = new LinkedList<Entry>();
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a8 = (Entry)a2.next();
            a7.add(new Entry(a8.m, Math.pow(a8.H, scalar)));
            iterator = a2;
        }
        return new SparseVector(this.m, a7);
    }

    @Override
    public double norm() {
        return this.norm(2);
    }

    public String toString() {
        java.util.Iterator a2;
        StringBuilder a3 = new StringBuilder();
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.append(a4.toString()).append("\n");
            iterator = a2;
        }
        return a3.toString();
    }

    @Override
    public int nnz() {
        return this.H.size();
    }

    @Override
    public double norm(int p2) {
        java.util.Iterator a2;
        if (p2 == Integer.MAX_VALUE) {
            return DoubleUtils.max(DoubleUtils.abs(this.toArray()));
        }
        if (p2 == Integer.MIN_VALUE) {
            return DoubleUtils.min(DoubleUtils.abs(this.toArray()));
        }
        double a3 = 0.0;
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3 += Math.pow(a4.H, p2);
            iterator = a2;
        }
        a3 = Math.pow(a3, 1.0 / (double)p2);
        return a3;
    }

    @Override
    SparseVector minus(SparseVector a2) {
        SparseVector a3;
        return a3.H(a2, -1);
    }

    SparseVector multiply(SparseVector a2) {
        SparseVector a3;
        IsVector.equalSize(a3, a2);
        LinkedList<Entry> a4 = new LinkedList<Entry>();
        java.util.Iterator a5 = a3.H.iterator();
        java.util.Iterator a6 = a2.H.iterator();
        Entry a7 = a5.hasNext() ? (Entry)a5.next() : null;
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry entry = a7;
        while (entry != null && a8 != null) {
            if (a7.m < a8.m) {
                entry = a7 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            if (a7.m > a8.m) {
                a8 = a6.hasNext() ? (Entry)a6.next() : null;
                entry = a7;
                continue;
            }
            double a9 = a7.H * a8.H;
            if (Double.compare(0.0, a9) != 0) {
                a4.add(new Entry(a7.m, a9));
            }
            a7 = a5.hasNext() ? (Entry)a5.next() : null;
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            entry = a7;
        }
        return new SparseVector(a3.m, a4);
    }

    @Override
    public Vector add(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.H((SparseVector)that, 1);
        }
        IsVector.equalSize(this, that);
        DenseVector a3 = new DenseVector(that);
        java.util.Iterator iterator = a2 = this.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.m, a4.H + a3.get(a4.m));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Vector opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Vector multiply(Vector v) {
        java.util.Iterator a2;
        if (v instanceof SparseVector) {
            return this.multiply((SparseVector)v);
        }
        IsVector.equalSize(this, v);
        SparseVector a3 = new SparseVector(this);
        java.util.Iterator iterator = a2 = a3.H.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.m, a4.H * v.get(a4.m));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Vector minus(double scalar) {
        return this.add(-scalar);
    }

    @Override
    public SparseVector deepCopy() {
        return new SparseVector(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<Entry> {
        private final ListIterator<Entry> H;

        @Override
        public boolean hasNext() {
            return this.H.hasNext();
        }

        @Override
        public Entry next() {
            return this.H.next();
        }

        Iterator(ListIterator<Entry> a2) {
            Iterator a3;
            a3.H = a2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(b.C("vux{~`2gxyqc|4{{%qjplqla-}`5h4|pV`Yg\n4ApI4Wa\u0019`U5_qTz\u0001}LfYqO1"));
        }
    }

    public static class Entry {
        private int m;
        private double H;

        Entry(int a2, double a3) {
            Entry a4;
            a4.m = a2;
            a4.H = a3;
        }

        public double value() {
            return this.H;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.m;
            objectArray[1] = this.H;
            return String.format(b.C("F9z@994)3"), objectArray);
        }

        public int index() {
            return this.m;
        }
    }
}

