/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.AbsoluteTolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public interface IterativeSolver {
    public Vector solve(Problem var1) throws ConvergenceFailure;

    public Vector solve(Problem var1, IterationMonitor var2) throws ConvergenceFailure;

    public static class ConvergenceFailure
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Reason H;

        public ConvergenceFailure(Reason reason, String message) {
            super(message);
            this.H = reason;
        }

        public ConvergenceFailure(Reason reason) {
            this.H = reason;
        }

        public Reason reason() {
            return this.H;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Reason
        extends Enum<Reason> {
            public static final /* enum */ Reason ITERATIONS;
            public static final /* enum */ Reason BREAKDOWN;
            private static final /* synthetic */ Reason[] $VALUES;

            public static Reason[] values() {
                return (Reason[])$VALUES.clone();
            }

            static {
                BREAKDOWN = new Reason();
                ITERATIONS = new Reason();
                Reason[] reasonArray = new Reason[2];
                reasonArray[0] = BREAKDOWN;
                reasonArray[1] = ITERATIONS;
                $VALUES = reasonArray;
            }

            private Reason() {
                Reason a2;
            }

            public static Reason valueOf(String name) {
                return Enum.valueOf(Reason.class, name);
            }
        }
    }

    public static class Problem {
        private Tolerance C;
        private Preconditioner F;
        private final Vector B;
        private int G;
        private final Matrix M;
        private Preconditioner m;
        private Vector H;

        public Matrix A() {
            return this.M.deepCopy();
        }

        public Problem tolerance(Tolerance tolerance) {
            this.C = tolerance;
            return this;
        }

        public Problem rightPreconditioner(Preconditioner preconditioner) {
            this.F = preconditioner;
            return this;
        }

        public Tolerance tolerance() {
            return this.C;
        }

        public Preconditioner leftPreconditioner() {
            return this.m;
        }

        public int maxIteration() {
            return this.G;
        }

        public Problem(Matrix A, Vector b2) {
            SuanShuUtils.assertArgument(A.nRows() == b2.size(), b.C("T3e5\u007ff}bn4s`j`:ptagy!`m5o3}5z}p0"));
            this.M = A.deepCopy();
            this.B = b2.deepCopy();
            this.G = Integer.MAX_VALUE;
            this.C = new AbsoluteTolerance();
            this.H = new SparseVector(A.nCols());
            this.m = new IdentityPreconditioner();
            this.F = new IdentityPreconditioner();
        }

        public Problem initialGuess(Vector initialGuess) {
            this.H = initialGuess;
            return this;
        }

        public Problem maxIteration(int maxIteration) {
            this.G = maxIteration;
            return this;
        }

        public Problem leftPreconditioner(Preconditioner preconditioner) {
            this.m = preconditioner;
            return this;
        }

        public Preconditioner rightPreconditioner() {
            return this.F;
        }

        public Vector initialGuess() {
            return this.H;
        }

        public Vector b() {
            return this.B.deepCopy();
        }
    }
}

