/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BiconjugateGradientStabilizedSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public BiconjugateGradientStabilizedSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public BiconjugateGradientStabilizedSolver() {
        this(50);
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        Vector a11 = a10.deepCopy();
        Vector a12 = a9.ZERO();
        Vector a13 = a9.ZERO();
        double a14 = 1.0;
        double a15 = 1.0;
        double a16 = 1.0;
        int a17 = 1;
        boolean a18 = false;
        a18 = a5.updateResidualNorm(a10.norm());
        int n = a17;
        int n2 = a4;
        while (n <= n2 && !a18) {
            BiconjugateGradientStabilizedSolver a19;
            a8.addIterate(a9);
            if (Double.compare(a16, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("rq{zx<'=e"));
            }
            double a20 = a11.innerProduct(a10);
            if (Double.compare(a20, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("&iMsr\u007fx62i/:+;e"));
            }
            double a21 = a20 / a14 * (a15 / a16);
            Vector a22 = a7.solve(a12 = a10.add(a12.minus(a13.scaled(a16)).scaled(a21)));
            double a23 = a11.innerProduct(a13 = a2.multiply(a22));
            if (Double.compare(a23, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("&iMsr\u007fx62m/:+;e"));
            }
            a15 = a20 / a23;
            Vector a24 = a10.minus(a13.scaled(a15));
            a18 = a5.updateResidualNorm(a24.norm());
            if (a18) {
                a9 = a9.add(a22.scaled(a15));
                break;
            }
            Vector a25 = a7.solve(a24);
            Vector a26 = a2.multiply(a25);
            a16 = a26.innerProduct(a24) / a26.innerProduct(a26);
            a9 = a9.add(a22.scaled(a15)).add(a25.scaled(a16));
            a10 = a17 % a19.H != 0 ? a24.minus(a26.scaled(a16)) : a3.minus(a2.multiply(a9));
            a14 = a20;
            a18 = a5.updateResidualNorm(a10.norm());
            n = ++a17;
            n2 = a4;
        }
        a8.addIterate(a9);
        if (!a18) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }
}

